/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.ability;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.common.ability.base.AbilityClientProperties;
import chappie.modulus.util.ClientUtil;
import chappie.modulus.util.IHasTimer;
import chappie.modulus.util.model.ModelProperties;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import org.joml.Matrix4f;

public class LightingAbility
extends Ability
implements IHasTimer {
    public static final class_2960 WHITE = class_2960.method_60655((String)"theboys", (String)"textures/models/white.png");
    public IHasTimer.Timer timer = new IHasTimer.Timer(() -> 10, () -> ((LightingAbility)this).isEnabled());

    public LightingAbility(class_1309 entity, AbilityBuilder builder) {
        super(entity, builder);
    }

    public void initializeClient(Consumer<AbilityClientProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new AbilityClientProperties(){
            private List<class_243> beamVectors;

            public void generateLightningBeams() {
                Random random = new Random();
                this.beamVectors = new ArrayList<class_243>();
                class_243 coreStart = new class_243(0.0, 0.0, 0.0);
                int coreLength = random.nextInt(3) + 7;
                for (int core = 0; core < coreLength; ++core) {
                    class_243 coreEnd = coreStart.method_1031(0.0, 0.0, 1.0).method_1019(this.randomVector(random, 0.3f).method_18805(2.5, 2.5, 2.5));
                    this.beamVectors.add(coreStart);
                    this.beamVectors.add(coreEnd);
                    coreStart = coreEnd;
                    this.beamVectors.addAll(this.generateBranch(random, coreEnd, 1, 0.5f, 1));
                }
            }

            private List<class_243> generateBranch(Random random, class_243 origin, int maxLength, float splitChance, int recursionCount) {
                ArrayList<class_243> branchSegments = new ArrayList<class_243>();
                class_243 branchStart = origin;
                int branches = random.nextInt(maxLength + 1);
                int dir = random.nextBoolean() ? 1 : -1;
                float branchLength = 0.75f / (float)(recursionCount + 1);
                for (int i = 0; i < branches; ++i) {
                    class_243 branchEnd = branchStart.method_1031((double)((float)dir * branchLength), 0.0, (double)branchLength).method_1019(this.randomVector(random, 0.3f));
                    branchSegments.add(branchStart);
                    branchSegments.add(branchEnd);
                    if (random.nextFloat() <= splitChance) {
                        branchSegments.addAll(this.generateBranch(random, branchEnd, maxLength - 1, splitChance * 1.2f, recursionCount + 1));
                    }
                    branchStart = branchEnd;
                }
                return branchSegments;
            }

            private class_243 randomVector(Random random, float radius) {
                double x = random.nextDouble() * 2.0 * (double)radius - (double)radius;
                double y = random.nextDouble() * 2.0 * (double)radius - (double)radius;
                double z = random.nextDouble() * 2.0 * (double)radius - (double)radius;
                return new class_243(x, y, z);
            }

            public List<class_243> getBeamCache() {
                if (this.beamVectors == null) {
                    this.generateLightningBeams();
                }
                return this.beamVectors;
            }

            public void render(class_922<? extends class_1309, ? extends class_583<?>> renderer, class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_1309 entity, ModelProperties modelProperties) {
                class_583 class_5832 = renderer.method_4038();
                if (!(class_5832 instanceof class_572)) {
                    return;
                }
                class_572 model = (class_572)class_5832;
                for (int k = 0; k < 2; ++k) {
                    float width;
                    poseStack.method_22903();
                    model.method_2803(k == 0 ? class_1306.field_6183 : class_1306.field_6182, poseStack);
                    if (k == 0) {
                        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                    }
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    poseStack.method_22904(0.075, 0.0, 0.6);
                    if (entity.field_6012 % 2 == 0 && !class_310.method_1551().method_1493()) {
                        this.generateLightningBeams();
                    }
                    List<class_243> segments = this.getBeamCache();
                    float f = LightingAbility.this.timer.value(modelProperties.partialTicks());
                    float height = width = 0.05f;
                    for (int i = 0; i < segments.size() - 1; i += 2) {
                        class_243 from = segments.get(i);
                        class_243 to = segments.get(i + 1);
                        Color c = new Color(0, 156, 255);
                        Color c1 = new Color(0, 226, 255);
                        this.renderPart(from, to, width, height, poseStack, bufferIn.getBuffer(ClientUtil.ModRenderTypes.glow((class_2960)WHITE)), 1.0f, 1.0f, 1.0f, f);
                        class_4588 consumer = bufferIn.getBuffer(class_1921.method_42600((class_2960)WHITE));
                        this.renderPart(from, to, width + 0.1f, height + 0.1f, poseStack, consumer, (float)c1.getRed() / 255.0f, (float)c1.getGreen() / 255.0f, (float)c1.getBlue() / 255.0f, 0.1f * f);
                        this.renderPart(from, to, width + 0.2f, height + 0.2f, poseStack, consumer, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 0.1f * f);
                    }
                    poseStack.method_22909();
                }
            }

            private void renderPart(class_243 from, class_243 to, float width, float height, class_4587 poseStack, class_4588 consumer, float r, float g, float b, float a) {
                this.renderQuad(from.method_1023(0.0, (double)(height * 0.5f), 0.0), to.method_1023(0.0, (double)(height * 0.5f), 0.0), width, 0.0f, poseStack, consumer, r, g, b, a);
                this.renderQuad(from.method_1031(0.0, (double)(height * 0.5f), 0.0), to.method_1031(0.0, (double)(height * 0.5f), 0.0), width, 0.0f, poseStack, consumer, r, g, b, a);
                this.renderQuad(from.method_1023((double)(width * 0.5f), 0.0, 0.0), to.method_1023((double)(width * 0.5f), 0.0, 0.0), 0.0f, height, poseStack, consumer, r, g, b, a);
                this.renderQuad(from.method_1031((double)(width * 0.5f), 0.0, 0.0), to.method_1031((double)(width * 0.5f), 0.0, 0.0), 0.0f, height, poseStack, consumer, r, g, b, a);
            }

            private void renderQuad(class_243 from, class_243 to, float width, float height, class_4587 poseStack, class_4588 consumer, float r, float g, float b, float a) {
                class_4587.class_4665 pose = poseStack.method_23760();
                Matrix4f poseMatrix = poseStack.method_23760().method_23761();
                float halfWidth = width * 0.5f;
                float halfHeight = height * 0.5f;
                consumer.method_22918(poseMatrix, (float)from.field_1352 - halfWidth, (float)from.field_1351 - halfHeight, (float)from.field_1350).method_22915(r, g, b, a).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(240).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_22918(poseMatrix, (float)from.field_1352 + halfWidth, (float)from.field_1351 + halfHeight, (float)from.field_1350).method_22915(r, g, b, a).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(240).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_22918(poseMatrix, (float)to.field_1352 + halfWidth, (float)to.field_1351 + halfHeight, (float)to.field_1350).method_22915(r, g, b, a).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(240).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_22918(poseMatrix, (float)to.field_1352 - halfWidth, (float)to.field_1351 - halfHeight, (float)to.field_1350).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(240).method_60831(pose, 0.0f, 1.0f, 0.0f);
            }
        });
    }

    public List<IHasTimer.Timer> timers() {
        return List.of(this.timer);
    }
}

