/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.ability.interfaces;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityClientProperties;
import chappie.modulus.common.ability.base.condition.Condition;
import chappie.modulus.common.ability.base.condition.KeyCondition;
import chappie.modulus.util.KeyMap;
import chappie.theboys.client.TBOverlays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;

public class IHasOverlay
implements AbilityClientProperties {
    private final Ability ability;
    private Supplier<Integer> uOffset = () -> 16;
    private Supplier<Integer> vOffset = () -> 0;
    private Supplier<Integer> backgroundColor = () -> -1;
    private Supplier<KeyMap.KeyType> keyType = null;

    public IHasOverlay(Ability ability, Consumer<IHasOverlay> builder) {
        this.ability = ability;
        builder.accept(this);
        this.ability.clientProperties.add(this);
    }

    public static IHasOverlay getInstance(Ability ability) {
        for (AbilityClientProperties clientProperty : ability.clientProperties) {
            if (!(clientProperty instanceof IHasOverlay)) continue;
            IHasOverlay overlay = (IHasOverlay)clientProperty;
            if (ability.isHidden()) continue;
            return overlay;
        }
        return null;
    }

    public IHasOverlay uvOffset(Supplier<Integer> u, Supplier<Integer> v) {
        this.uOffset = u;
        this.vOffset = v;
        return this;
    }

    public IHasOverlay uOffset(int u) {
        return this.uvOffset(() -> u, () -> 0);
    }

    public IHasOverlay keyType(Supplier<KeyMap.KeyType> keyType) {
        this.keyType = keyType;
        return this;
    }

    public IHasOverlay backgroundColor(Supplier<Integer> backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public KeyMap.KeyType getKeyType() {
        if (this.keyType == null) {
            for (Condition enabling : this.ability.conditionManager.conditionsFor("enabling")) {
                if (!(enabling instanceof KeyCondition)) continue;
                KeyCondition keyCondition = (KeyCondition)enabling;
                return keyCondition.keyType;
            }
            return null;
        }
        return this.keyType.get();
    }

    public void renderIcon(int x, int y, float alpha, class_310 mc, class_329 gui, class_332 guiGraphics, float partialTick, int width, int height) {
        guiGraphics.method_25290(TBOverlays.TEXTURE, x, y, (float)this.uOffset.get().intValue(), (float)this.vOffset.get().intValue(), 16, 16, 256, 256);
    }
}

