/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.block.entity;

import chappie.modulus.util.IHasTimer;
import chappie.theboys.common.block.entity.TBBlockEntities;
import chappie.theboys.common.block.menu.SynthesizerMenu;
import chappie.theboys.common.item.TBItems;
import chappie.theboys.common.item.VialItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1814;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2609;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SynthesizerBlockEntity
extends class_2624
implements GeoBlockEntity,
IHasTimer {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int tickCount;
    int waterMb = 0;
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime = 200;
    public final IHasTimer.Timer workTimer = new IHasTimer.Timer(() -> 5, this::isWork);
    public final IHasTimer.Timer rollTimer = new RollTimer(this::isWork);
    boolean work;
    private boolean opened = true;
    public final IHasTimer.Timer openTimer = new IHasTimer.Timer(() -> 5, () -> this.opened);
    private class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            SynthesizerBlockEntity be = SynthesizerBlockEntity.this;
            return switch (index) {
                case 0 -> {
                    if (be.work) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> be.waterMb;
                case 2 -> {
                    if (be.method_5442()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> be.litTime;
                case 4 -> be.litDuration;
                case 5 -> be.cookingProgress;
                case 6 -> be.cookingTotalTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            SynthesizerBlockEntity be = SynthesizerBlockEntity.this;
            switch (index) {
                case 0: {
                    be.setWork(value != 0);
                    break;
                }
                case 1: {
                    be.setWaterMb(value);
                    break;
                }
                case 3: {
                    be.litTime = value;
                    break;
                }
                case 4: {
                    be.litDuration = value;
                    break;
                }
                case 5: {
                    be.cookingProgress = value;
                    break;
                }
                case 6: {
                    be.cookingTotalTime = value;
                }
            }
        }

        public int method_17389() {
            return 7;
        }
    };

    public SynthesizerBlockEntity(class_2338 pos, class_2680 blockState) {
        super(TBBlockEntities.SYNTHESIZER, pos, blockState);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.theboys.synthesizer");
    }

    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new SynthesizerMenu(containerId, inventory, (class_1263)this, this.dataAccess);
    }

    public int method_5439() {
        return this.method_11282().size();
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.waterMb = tag.method_10550("waterMb");
        this.work = tag.method_10577("work");
        this.opened = tag.method_10577("opened");
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.method_11282(), (class_7225.class_7874)registries);
        this.litTime = tag.method_10568("burnTime");
        this.cookingProgress = tag.method_10568("time");
        this.cookingTotalTime = tag.method_10568("timeTotal");
        this.litDuration = this.getBurnDuration((class_1799)this.items.get(1));
    }

    protected int getBurnDuration(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        return class_2609.method_11196().getOrDefault(fuel.method_7909(), 0);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("waterMb", this.waterMb);
        tag.method_10556("work", this.work);
        tag.method_10556("opened", this.opened);
        class_1262.method_5426((class_2487)tag, this.method_11282(), (class_7225.class_7874)registries);
        tag.method_10575("burnTime", (short)this.litTime);
        tag.method_10575("time", (short)this.cookingProgress);
        tag.method_10575("timeTotal", (short)this.cookingTotalTime);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.method_11282(), (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.markUpdated();
        }
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.method_11282().set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.markUpdated();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.method_11282()) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean isCentrifugeEmpty() {
        List list = this.method_11282().subList(3, 9);
        for (class_1799 itemStack : list) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public int numOfVials() {
        int i = 0;
        for (class_1799 itemStack : this.method_11282().subList(3, 9)) {
            if (itemStack.method_7960()) continue;
            itemStack.method_7934(1);
            ++i;
        }
        return i;
    }

    public float getBurnProgress() {
        int i = this.cookingProgress;
        int j = this.cookingTotalTime;
        return j != 0 && i != 0 ? class_3532.method_15363((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.method_11282().get(slot);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.method_11282(), (int)slot);
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.method_11282().clear();
    }

    public class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    private void markUpdated() {
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
        this.markUpdated();
        this.setWork(!opened);
    }

    public boolean setWaterMb(int waterMb) {
        if (waterMb <= 500) {
            this.waterMb = Math.max(0, waterMb);
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean isWork() {
        return this.getBurnProgress() != 0.0f;
    }

    public void setWork(boolean work) {
        boolean work1;
        boolean bl = work1 = this.waterMb != 0 && !this.isCentrifugeEmpty() && !((class_1799)this.method_11282().get(2)).method_7960() && ((class_1799)this.method_11282().get(2)).method_7947() <= 1;
        if (work1) {
            if (this.opened) {
                this.setOpened(false);
            }
            this.work = work;
            this.markUpdated();
        }
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state) {
        class_1799 waterStack;
        this.cookingTotalTime = 200;
        ++this.tickCount;
        for (IHasTimer.Timer timer : this.timers()) {
            timer.update();
        }
        if (this.opened || this.waterMb == 0 || this.isCentrifugeEmpty() || ((class_1799)this.method_11282().get(2)).method_7960() || ((class_1799)this.method_11282().get(2)).method_7947() > 1) {
            this.work = false;
            this.markUpdated();
        }
        if (!(waterStack = (class_1799)this.items.get(0)).method_7960()) {
            class_1844 potionContents = (class_1844)waterStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
            if (waterStack.method_31574(class_1802.field_8574) && potionContents.method_57401(class_1847.field_8991)) {
                if (this.setWaterMb(this.waterMb + 25)) {
                    this.items.set(0, (Object)class_1802.field_8469.method_7854());
                }
            } else if (waterStack.method_31574(class_1802.field_8705) && this.setWaterMb(this.waterMb + 100)) {
                this.items.set(0, (Object)class_1802.field_8550.method_7854());
            }
        }
        boolean bl = this.isLit();
        boolean bl2 = false;
        if (this.isLit()) {
            --this.litTime;
        }
        class_1799 fuelStack = (class_1799)this.items.get(1);
        if (!this.isLit() && !fuelStack.method_7960() && this.work) {
            this.litDuration = this.litTime = this.getBurnDuration(fuelStack);
            if (this.isLit()) {
                bl2 = true;
                class_1792 item = fuelStack.method_7909();
                fuelStack.method_7934(1);
                if (fuelStack.method_7960()) {
                    class_1792 item2 = item.method_7858();
                    this.items.set(1, (Object)(item2 == null ? class_1799.field_8037 : new class_1799((class_1935)item2)));
                }
            }
        }
        if (this.isLit() && this.work) {
            ++this.cookingProgress;
            int i = level.field_9229.method_43048(6);
            if (this.cookingProgress % (this.cookingTotalTime / 10) == 0 && !this.setWaterMb(this.waterMb - 25)) {
                this.setWork(false);
            }
            if (this.cookingProgress % (this.cookingTotalTime / 10) == 0 && level.field_9229.method_43048(100) <= 25) {
                this.method_5434(3 + i, 1);
            }
            if (this.cookingProgress == this.cookingTotalTime) {
                this.cookingProgress = 0;
                this.cookingTotalTime = 200;
                class_1799 stack = (class_1799)this.items.get(2);
                class_1799 resultItem = TBItems.VIAL.method_7854();
                int vials = this.numOfVials();
                if (stack.method_31574(class_1802.field_8635) || stack.method_7932() != class_1814.field_8906 || stack.method_7909() instanceof class_1812) {
                    if (vials < 3 ? level.field_9229.method_43048(100) < 75 : level.field_9229.method_43048(100) < 50) {
                        resultItem = VialItem.compoundV();
                    }
                } else if (level.field_9229.method_43048(100) <= 25) {
                    resultItem = VialItem.compoundV();
                } else if (level.field_9229.method_43048(100) <= 40) {
                    class_1799 potionStack = new class_1799((class_1935)class_1802.field_8574);
                    class_1842 potion = class_7923.field_41179.method_10220().filter(p -> class_7923.field_41179.method_10221(p).method_12836().equals("minecraft") && !p.method_8049().isEmpty()).findAny().get();
                    potionStack.method_57379(class_9334.field_49651, (Object)new class_1844(class_7923.field_41179.method_47983((Object)potion)));
                    resultItem = potionStack;
                }
                stack.method_7934(1);
                if (stack.method_7960()) {
                    this.items.set(2, (Object)resultItem.method_46651(vials));
                }
                this.setOpened(true);
                bl2 = true;
            }
        } else {
            this.cookingProgress = this.cookingProgress > this.cookingTotalTime / 2 ? 0 : class_3532.method_15340((int)(this.cookingProgress - 1), (int)0, (int)this.cookingTotalTime);
            if (this.cookingProgress == 0 && this.work) {
                this.setWork(false);
            }
        }
        if (bl != this.isLit()) {
            bl2 = true;
        }
        if (bl2) {
            SynthesizerBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public Iterable<IHasTimer.Timer> timers() {
        return List.of(this.openTimer, this.workTimer, this.rollTimer);
    }

    public static class RollTimer
    extends IHasTimer.Timer {
        public RollTimer(Supplier<Boolean> predicate) {
            super(() -> 20, predicate);
        }

        public void update() {
            int maxTimer = (Integer)this.maxTimer.get();
            boolean predicate = (Boolean)this.predicate.get();
            if (this.timer >= maxTimer) {
                this.timer = 0;
            }
            this.prevTimer = this.timer;
            if (this.timer < maxTimer && predicate) {
                ++this.timer;
            }
            if (this.timer > 0 && !predicate) {
                this.timer = this.timer > maxTimer / 2 ? ++this.timer : --this.timer;
            }
        }
    }
}

