/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.customsheepbreeding.config;

import com.github.theredbrain.customsheepbreeding.CustomSheepBreeding;
import java.util.HashMap;
import java.util.Map;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.annotations.Comment;
import me.fzzyhmstrs.fzzy_config.annotations.ConvertFrom;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresAction;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.util.Walkable;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedMap;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedAny;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedEnum;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedString;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1767;

@ConvertFrom(fileName="server.json5", folder="customsheepbreeding")
public class ServerConfig
extends Config {
    @Comment(value="When set to true, the color of sheep can't be changed permanently with dye items.\nWhen a dye item is used, the sheep's color is changed until it is sheared.\nThe natural color is used when determining the child color.\n\nFor vanilla behaviour change this to false\n")
    public ValidatedBoolean enable_natural_colors = new ValidatedBoolean(true);
    public ValidatedBoolean enable_custom_colors = new ValidatedBoolean(true);
    @Comment(value="Default spawn colors and their weight\n\n(in the default configuration this translates to:\na 81.836% chance for white,\na 0.164% chance for pink,\na 5% chance for black,\na 5% chance for gray,\na 5% chance for light_gray,\na 3% chance for brown)\n\nThe default values are equal to the vanilla temperate colors\n")
    @RequiresAction(action=Action.RESTART)
    public ValidatedAny<SheepColorConfig> initial_color_default = new ValidatedAny((Object)new SheepColorConfig(82, class_1767.field_7952, 499, class_1767.field_7954, 1, class_1767.field_7963, 5, class_1767.field_7944, 5, class_1767.field_7967, 5, class_1767.field_7957, 3));
    @Comment(value="Spawn colors and their weight for biomes in the defined tag\n\nThe default values are equal to the vanilla warm and cold colors\n")
    @RequiresAction(action=Action.RESTART)
    public ValidatedMap<String, SheepColorConfig> initial_color_variants = new ValidatedMap((Map)new HashMap<String, SheepColorConfig>(){
        {
            this.put("minecraft:spawns_warm_variant_farm_animals", new SheepColorConfig(82, class_1767.field_7957, 499, class_1767.field_7954, 1, class_1767.field_7944, 5, class_1767.field_7967, 5, class_1767.field_7952, 5, class_1767.field_7963, 3));
            this.put("minecraft:spawns_cold_variant_farm_animals", new SheepColorConfig(82, class_1767.field_7963, 499, class_1767.field_7954, 1, class_1767.field_7967, 5, class_1767.field_7944, 5, class_1767.field_7952, 5, class_1767.field_7957, 3));
        }
    }, (Entry)new ValidatedString(), (Entry)new ValidatedAny((Object)new SheepColorConfig()));
    @Comment(value="Weight for the child to get the color of the first parent\n\n(in the default configuration this translates to a 38% chance)\n\nFor vanilla behaviour change this to 0\n")
    public ValidatedInt parent_color_1_weight = new ValidatedInt(114);
    @Comment(value="Weight for the child to get the color of the second parent\n\n(in the default configuration this translates to a 38% chance)\n\nFor vanilla behaviour change this to 0\n")
    public ValidatedInt parent_color_2_weight = new ValidatedInt(114);
    @Comment(value="Special mutation colors and their weight\n\n(in the default configuration this translates to:\na 3% chance for black,\na 0.33% chance for light_blue,\na 0.33% chance for lime,\na 0.33% chance for pink)\n\nFor vanilla behaviour change this to []\n")
    public ValidatedMap<class_1767, Integer> mutation_colors = new ValidatedMap((Map)new HashMap<class_1767, Integer>(){
        {
            this.put(class_1767.field_7963, 9);
            this.put(class_1767.field_7951, 1);
            this.put(class_1767.field_7961, 1);
            this.put(class_1767.field_7954, 1);
        }
    }, (Entry)new ValidatedEnum((Enum)class_1767.field_7952, ValidatedEnum.WidgetType.CYCLING), (Entry)new ValidatedInt(0));
    @Comment(value="Weight for the child's color to be a blend of the colors of both parents\n(in the default configuration this translates to a 20% chance)\n\nBy default the blend has an equal chance to be one of the parents colors\nExceptions can be defined below\n\nFor vanilla behaviour change this to 1\n")
    public ValidatedInt blending_color_weight = new ValidatedInt(60);
    @Comment(value="Blending exceptions are defined here\n\nNote that by default both permutations for the color pair of black and white are defined\nThis means when breeding a black and white sheep there is an equal chance for the child to become gray or light_gray\n\nFor vanilla behaviour change this to\n[\"black+white:gray\",\"blue+green:cyan\",\"blue+red:purple\",\"blue+white:light_blue\",\"gray+white:light_gray\",\"green+white:lime\",\"pink+purple:magenta\",\"red+white:pink\",\"red+yellow:orange\"]\n")
    public ValidatedMap<DyeColorPair, class_1767> color_blending_exceptions = new ValidatedMap((Map)new HashMap<DyeColorPair, class_1767>(){
        {
            this.put(new DyeColorPair(class_1767.field_7963, class_1767.field_7952), class_1767.field_7944);
            this.put(new DyeColorPair(class_1767.field_7952, class_1767.field_7963), class_1767.field_7967);
            this.put(new DyeColorPair(class_1767.field_7963, class_1767.field_7967), class_1767.field_7944);
            this.put(new DyeColorPair(class_1767.field_7944, class_1767.field_7952), class_1767.field_7967);
            this.put(new DyeColorPair(class_1767.field_7963, class_1767.field_7951), class_1767.field_7966);
            this.put(new DyeColorPair(class_1767.field_7963, class_1767.field_7961), class_1767.field_7942);
            this.put(new DyeColorPair(class_1767.field_7963, class_1767.field_7954), class_1767.field_7964);
            this.put(new DyeColorPair(class_1767.field_7966, class_1767.field_7954), class_1767.field_7958);
            this.put(new DyeColorPair(class_1767.field_7964, class_1767.field_7951), class_1767.field_7958);
            this.put(new DyeColorPair(class_1767.field_7963, class_1767.field_7958), class_1767.field_7945);
            this.put(new DyeColorPair(class_1767.field_7964, class_1767.field_7966), class_1767.field_7945);
            this.put(new DyeColorPair(class_1767.field_7966, class_1767.field_7942), class_1767.field_7955);
            this.put(new DyeColorPair(class_1767.field_7964, class_1767.field_7942), class_1767.field_7947);
            this.put(new DyeColorPair(class_1767.field_7955, class_1767.field_7964), class_1767.field_7957);
            this.put(new DyeColorPair(class_1767.field_7947, class_1767.field_7964), class_1767.field_7946);
        }
    }, (Entry)new ValidatedAny((Object)new DyeColorPair()), (Entry)new ValidatedEnum((Enum)class_1767.field_7952, ValidatedEnum.WidgetType.CYCLING));

    public ServerConfig() {
        super(CustomSheepBreeding.identifier("server"));
    }

    @Translation(prefix="customsheepbreeding.server.sheep_color_config")
    public static class SheepColorConfig
    implements Walkable {
        public int default_weight;
        public class_1767 main_color;
        public int main_weight;
        public class_1767 rare_color;
        public int rare_weight;
        public class_1767 bonus_color_1;
        public int bonus_weight_1;
        public class_1767 bonus_color_2;
        public int bonus_weight_2;
        public class_1767 bonus_color_3;
        public int bonus_weight_3;
        public class_1767 bonus_color_4;
        public int bonus_weight_4;

        public SheepColorConfig() {
            this(0, class_1767.field_7952, 0, class_1767.field_7952, 0, class_1767.field_7952, 0, class_1767.field_7952, 0, class_1767.field_7952, 0, class_1767.field_7952, 0);
        }

        public SheepColorConfig(int default_weight, class_1767 main_color, int main_weight, class_1767 rare_color, int rare_weight, class_1767 bonus_color_1, int bonus_weight_1, class_1767 bonus_color_2, int bonus_weight_2, class_1767 bonus_color_3, int bonus_weight_3, class_1767 bonus_color_4, int bonus_weight_4) {
            this.default_weight = default_weight;
            this.main_color = main_color;
            this.main_weight = main_weight;
            this.rare_color = rare_color;
            this.rare_weight = rare_weight;
            this.bonus_color_1 = bonus_color_1;
            this.bonus_weight_1 = bonus_weight_1;
            this.bonus_color_2 = bonus_color_2;
            this.bonus_weight_2 = bonus_weight_2;
            this.bonus_color_3 = bonus_color_3;
            this.bonus_weight_3 = bonus_weight_3;
            this.bonus_color_4 = bonus_color_4;
            this.bonus_weight_4 = bonus_weight_4;
        }

        public String toString() {
            return "default_weight: " + this.default_weight + ", main_color: " + String.valueOf(this.main_color) + ", main_weight: " + this.main_weight + ", rare_color: " + String.valueOf(this.rare_color) + ", rare_weight: " + this.rare_weight + ", bonus_color_1: " + String.valueOf(this.bonus_color_1) + ", bonus_weight_1: " + this.bonus_weight_1 + ", bonus_color_2: " + String.valueOf(this.bonus_color_2) + ", bonus_weight_2: " + this.bonus_weight_2 + ", bonus_color_3: " + String.valueOf(this.bonus_color_3) + ", bonus_weight_3: " + this.bonus_weight_3 + ", bonus_color_4: " + String.valueOf(this.bonus_color_4) + ", bonus_color_4: " + this.bonus_weight_4;
        }
    }

    @Translation(prefix="customsheepbreeding.server.dye_color_pair")
    public static class DyeColorPair
    implements Walkable {
        public class_1767 color_1;
        public class_1767 color_2;

        public DyeColorPair() {
            new DyeColorPair(class_1767.field_7952, class_1767.field_7952);
        }

        public DyeColorPair(class_1767 color_1, class_1767 color_2) {
            this.color_1 = color_1;
            this.color_2 = color_2;
        }

        public String toString() {
            return "color_1: " + String.valueOf(this.color_1) + ", color_2: " + String.valueOf(this.color_2);
        }
    }
}

