/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf;

import net.minecraft.world.entity.Entity;

public enum QuestDialogue {
    QUEST_MIKE_0(new String[]{"Welcome to the End&, ", "After the fall of the first dragon&, some of my kind have started to regain their sapience.", "Shortly after&, the flora flourished too.& Numerous pools have appeared on the surface down below.", "Please&, bring me a liquid chorus energy bucket."}),
    QUEST_MIKE_1(new String[]{"You might have noticed the floating structures nearby.", "I've seen multiple masked figures come and go&, sometimes carrying Shulkers inside&, but I'm yet to see any come back out.", "Could you please investigate the fate of those Shulkers?"}),
    QUEST_MIKE_2(new String[]{"...", "Whatever these individuals are up to&, we must put a stop to it.", "See if you can find any documents on any personnel inside the facility."}),
    QUEST_MIKE_3(new String[]{"We'll need some sort of a translation device.& I'll be able to make one with a server circuit board."}),
    QUEST_MIKE_4(new String[]{"The Dreadnought Confederation is expanding throughout the End at an alarming rate.& We must stop them before it's too late."}),
    QUEST_COMMANDER_0(new String[]{"Hey&, you're new around here.& I would usually offer to show you around the city&, but you've come at an unfortunate time.& Say&, think you could help us out a bit?"}),
    QUEST_COMMANDER_1(new String[]{"Here&, take these few shards.& There is a blacksmith shop right up the stairs&, around the corner behind you.& Get a crimson guard sword and come back to me.", "And don't accidentally spend all your money on other stuff&, this is all I can spare for now."}),
    QUEST_COMMANDER_2(new String[]{"Now that you've proven you're cognitively sound enough to buy an item&, it's time for the real action.", "Some of my mates came back from Nyoldarria earlier today.& They looked a bit sick&, but I didn't really think much of it&, at least until they all turned into walking skeletons.", "%Now I know we all are walking skeletons&, but those bones were trying to eat me.& They later all ran into the lower city&, and we can't really see them through the fog.", "Could you venture down there&, and bring me two distinct bone samples?", "It will help us with dealing with the problem&, and our local alchemist needs them for something."}),
    QUEST_COMMANDER_3(new String[]{"Great work down there&! While you were doing your thing&, we've managed to turn on one of the portals.", "You've been of great help so far&, but there is still more to do.& If you're interested&, take this kyanite pickaxe and town core.", "Go through the portal and place it in the green hills.& A good friend of mine will then come accompany you.", "Wish you luck on your future endeavours!"}),
    QUEST_COMMANDER_4(new String[]{"Hey!& How's your adventure going?& In case you got lost&, I left a note on the town core."}),
    QUEST_LUNA_0(new String[]{"Hello!& If I'm not mistaken&, you should be ", "Mike told me quite a great deal about you.& You seem quite experienced.& With the first dragon dead,& end corruption has greatly decreased,& allowing for the flora to regrow.", "But what if we were able to remove all of this corruption?", "Conveniently,& our \"friends\" from the Dreadnought Confederation,& in their quest of creating a teleportation device,& have instead made exactly what we need.", "Please look for and bring me a neonyte core."}),
    QUEST_LUNA_1(new String[]{"Awesome job!& I knew I could count on you ", "Now regarding the block itself...&& I've& never seen anything like it before.& It seems to be emiting gamma rays,& but the source of them remains unknown to me.", "Perhaps it's maintaining a low energy link to another location,& possibly a neutron star.& Those things are a sponge for void energy.", "If that is infact true,& we could use these to purge end corruption completely!", "Go back to The End and try activating the device,& then collect some of the material and try putting it in a blast furnace!"}),
    QUEST_LUNA_2(new String[]{"Hi again!& Thanks to you&, we have discovered that villagers can use a neonyte core as a workstation.& Make sure to sometime try that out and see what goods they can craft for you!"}),
    QUEST_SCOTT_0(new String[]{"Ah&, welcome to Concyderum, ", "Name's Scott&, and we've both been appointed expedition co-leaders.", "Now I don't know about you&, but I much prefer this over fighting those skeleton bastards&, or worse&, getting between the dreadnoughts and their oh-so-precious research.", "Sadly though&, there is a lot to do so don't expect this to be a holiday off to the blue shores.& We better start sooner rather than later&, before our problems pile up too much."}),
    QUEST_SCOTT_1(new String[]{"Our first immediate problem is the animals.", "You see&, I had this great idea of importing animals from the Overworld&, but then they started to munch down on every-funny looking mushroom they could find.", "Now their meat is wayyy too light-emitting for my taste&, and worse&, they have this constant swarm of flies around them."}),
    QUEST_SCOTT_2(new String[]{"We'll start with the cows&, see if you can bring me a sample of their meat.& Maybe we could find a way to salvage something&, or even cure it."}),
    QUEST_SCOTT_3(new String[]{"Next&, you'll have to manufacture some antifungal agent.& For this, you'll need some infested matter&, which can be obtained sometimes from the now local wildlife.", "We tried to extract it harmlessly via some bottles&, but the darn things just swallowed them whole.& At least saves you the trouble of having to bring your own."}),
    QUEST_SCOTT_4(new String[]{"Now would be a good time to try to get some meat samples from pigs and chickens too."}),
    QUEST_SCOTT_5(new String[]{"Using the antifungal agent from earlier&, you should be able to cure all the meat types using a brewing stand.", "Please do so and then come back with the various cured samples you are able to obtain."}),
    QUEST_SCOTT_6(new String[]{"Great!& While this doesn't completely solve our problems&, at least we have something to eat now!", "While you were gone&, I managed to gather up a few resources that could be helpful in establishing our outpost here.", "We've also come in contact with this enderman fellow&, they seem interested in talking to you."});

    private final String[] dialogueLines;

    private QuestDialogue(String[] lines) {
        this.dialogueLines = lines;
    }

    public String[] getLines() {
        return this.dialogueLines;
    }

    public String getLine(int index) {
        if (index < 0 || index >= this.dialogueLines.length) {
            return "";
        }
        return this.dialogueLines[index];
    }

    public int getLineCount() {
        return this.dialogueLines.length;
    }

    public static QuestDialogue fromNpcAndQuestLevel(String npcName, double questLevel) {
        try {
            String enumName = "QUEST_" + npcName.toUpperCase() + "_" + (int)questLevel;
            return QuestDialogue.valueOf(enumName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void setDialogueIfEmptyForNpc(Entity entity, String questGiver, double questLevel) {
        QuestDialogue dialogue = QuestDialogue.fromNpcAndQuestLevel(questGiver, questLevel);
        QuestDialogue.setDialogueIfEmpty(entity, dialogue);
    }

    public static void setDialogue(Entity entity, QuestDialogue dialogue) {
        if (dialogue == null || entity == null) {
            return;
        }
        String[] lines = dialogue.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String key = i == 0 ? "chatRaw" : "chatRaw" + (i - 1);
            entity.getPersistentData().putString(key, lines[i]);
        }
    }

    public static void setDialogueIfEmpty(Entity entity, QuestDialogue dialogue) {
        if (entity.getPersistentData().getString("chatRaw").isEmpty()) {
            QuestDialogue.setDialogue(entity, dialogue);
        }
    }
}

