/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.entity;

import eu.rxey.inf.init.EndertechinfModEntities;
import eu.rxey.inf.procedures.IsPoweredProcedure;
import eu.rxey.inf.procedures.OnStruckByLightningProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class ExoprawnEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_isPowered = SynchedEntityData.defineId(ExoprawnEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ExoprawnEntity(EntityType<ExoprawnEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_isPowered, (Object)true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.getNavigation().getNodeEvaluator().setCanOpenDoors(true);
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Evoker.class, true, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, true, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, true, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, SpellcasterIllager.class, true, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true, true));
        this.goalSelector.addGoal(9, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canUse() && IsPoweredProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canContinueToUse() && IsPoweredProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canUse() && IsPoweredProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canContinueToUse() && IsPoweredProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()){

            public boolean canUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canUse() && IsPoweredProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canContinueToUse() && IsPoweredProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canUse() && IsPoweredProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canContinueToUse() && IsPoweredProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canUse() && IsPoweredProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ExoprawnEntity.this.getX();
                double y = ExoprawnEntity.this.getY();
                double z = ExoprawnEntity.this.getZ();
                ExoprawnEntity entity = ExoprawnEntity.this;
                Level world = ExoprawnEntity.this.level();
                return super.canContinueToUse() && IsPoweredProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(15, (Goal)new BreakDoorGoal((Mob)this, e -> true));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.damage"));
    }

    public void thunderHit(ServerLevel serverWorld, LightningBolt lightningBolt) {
        super.thunderHit(serverWorld, lightningBolt);
        OnStruckByLightningProcedure.execute((Entity)this);
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataisPowered", ((Boolean)this.entityData.get(DATA_isPowered)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataisPowered")) {
            this.entityData.set(DATA_isPowered, (Object)compound.getBoolean("DataisPowered"));
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        ExoprawnEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        ExoprawnEntity entity = this;
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)EndertechinfModEntities.EXOPRAWN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.14);
        builder = builder.add(Attributes.MAX_HEALTH, 160.0);
        builder = builder.add(Attributes.ARMOR, 100.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 30.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 8.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }
}

