/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.entity;

import eu.rxey.inf.procedures.SCOnEntityTickUpdateProcedure;
import eu.rxey.inf.procedures.ServerControlEntityDiesProcedure;
import eu.rxey.inf.procedures.ServerControlOnInitialEntitySpawnProcedure;
import eu.rxey.inf.procedures.ServerControlPlaybackConditionAProcedure;
import eu.rxey.inf.procedures.ServerControlPlaybackConditionBProcedure;
import eu.rxey.inf.procedures.ServerControlPlaybackConditionCProcedure;
import eu.rxey.inf.procedures.ServerControlPlaybackConditionDProcedure;
import eu.rxey.inf.procedures.ServerControlPlaybackConditionEProcedure;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ServerControlEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_pose = SynchedEntityData.defineId(ServerControlEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);

    public ServerControlEntity(EntityType<ServerControlEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_pose, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"endertechinf:entity_server_control_step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"endertechinf:entity_server_control_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"endertechinf:entity_server_control_death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        ServerControlEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        ServerControlOnInitialEntitySpawnProcedure.execute((LevelAccessor)world);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datapose", ((Integer)this.entityData.get(DATA_pose)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datapose")) {
            this.entityData.set(DATA_pose, (Object)compound.getInt("Datapose"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(ServerControlPlaybackConditionBProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(ServerControlPlaybackConditionCProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(ServerControlPlaybackConditionDProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(ServerControlPlaybackConditionEProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(ServerControlPlaybackConditionAProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        SCOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.36);
        builder = builder.add(Attributes.MAX_HEALTH, 500.0);
        builder = builder.add(Attributes.ARMOR, 100.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 8.0);
        return builder;
    }
}

