/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.network;

import eu.rxey.inf.EndertechinfMod;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class EndertechinfModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"endertechinf");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        EndertechinfMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        EndertechinfMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"endertechinf", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"endertechinf", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean setting_polygons = false;
        public String chat_sprite = "\"sprite_tablet\"";
        public double ftp_hunger = 100.0;
        public double ftp_playerLocation = 0.0;
        public double ftp_sanity = 100.0;
        public double ftp_sleep = 100.0;
        public double HomeX = 0.0;
        public double HomeY = 0.0;
        public double HomeZ = 0.0;
        public double player_blacksmith_level = 5.0;
        public double player_blacksmith_page = 1.0;
        public boolean player_blood = false;
        public double player_bloodClock = 0.0;
        public double player_bloodKills = 0.0;
        public boolean player_bloodLustV = false;
        public boolean player_camcorder = false;
        public double player_end_quest = 0.0;
        public boolean player_isGrabbing = false;
        public boolean player_isThrowing = false;
        public double player_lastPlayed = 0.0;
        public String player_name = "\"\"";
        public double player_openShop = 0.0;
        public double player_questCommander = 0.0;
        public boolean player_questEnderman = false;
        public double player_questLuna = 0.0;
        public double player_questScott = 0.0;
        public double player_shards = 0.0;
        public double player_statArmour = 0.0;
        public double player_statAttack = 0.0;
        public double player_statDefabricthasm = 0.0;
        public double player_statRecovery = 0.0;
        public double player_statRegeneration = 0.0;
        public boolean player_tooMuch = false;
        public double player_topsideTokens = 0.0;
        public boolean player_translator = false;
        public double player_typeArmour = 0.0;
        public boolean player_volumetrics = false;
        public boolean setting_camera = true;
        public double setting_effects = 2.0;
        public boolean setting_mod_sky = true;
        public double vfx_fadeB = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("setting_polygons", this.setting_polygons);
            nbt.putString("chat_sprite", this.chat_sprite);
            nbt.putDouble("ftp_hunger", this.ftp_hunger);
            nbt.putDouble("ftp_playerLocation", this.ftp_playerLocation);
            nbt.putDouble("ftp_sanity", this.ftp_sanity);
            nbt.putDouble("ftp_sleep", this.ftp_sleep);
            nbt.putDouble("HomeX", this.HomeX);
            nbt.putDouble("HomeY", this.HomeY);
            nbt.putDouble("HomeZ", this.HomeZ);
            nbt.putDouble("player_blacksmith_level", this.player_blacksmith_level);
            nbt.putDouble("player_blacksmith_page", this.player_blacksmith_page);
            nbt.putBoolean("player_blood", this.player_blood);
            nbt.putDouble("player_bloodClock", this.player_bloodClock);
            nbt.putDouble("player_bloodKills", this.player_bloodKills);
            nbt.putBoolean("player_bloodLustV", this.player_bloodLustV);
            nbt.putBoolean("player_camcorder", this.player_camcorder);
            nbt.putDouble("player_end_quest", this.player_end_quest);
            nbt.putBoolean("player_isGrabbing", this.player_isGrabbing);
            nbt.putBoolean("player_isThrowing", this.player_isThrowing);
            nbt.putDouble("player_lastPlayed", this.player_lastPlayed);
            nbt.putString("player_name", this.player_name);
            nbt.putDouble("player_openShop", this.player_openShop);
            nbt.putDouble("player_questCommander", this.player_questCommander);
            nbt.putBoolean("player_questEnderman", this.player_questEnderman);
            nbt.putDouble("player_questLuna", this.player_questLuna);
            nbt.putDouble("player_questScott", this.player_questScott);
            nbt.putDouble("player_shards", this.player_shards);
            nbt.putDouble("player_statArmour", this.player_statArmour);
            nbt.putDouble("player_statAttack", this.player_statAttack);
            nbt.putDouble("player_statDefabricthasm", this.player_statDefabricthasm);
            nbt.putDouble("player_statRecovery", this.player_statRecovery);
            nbt.putDouble("player_statRegeneration", this.player_statRegeneration);
            nbt.putBoolean("player_tooMuch", this.player_tooMuch);
            nbt.putDouble("player_topsideTokens", this.player_topsideTokens);
            nbt.putBoolean("player_translator", this.player_translator);
            nbt.putDouble("player_typeArmour", this.player_typeArmour);
            nbt.putBoolean("player_volumetrics", this.player_volumetrics);
            nbt.putBoolean("setting_camera", this.setting_camera);
            nbt.putDouble("setting_effects", this.setting_effects);
            nbt.putBoolean("setting_mod_sky", this.setting_mod_sky);
            nbt.putDouble("vfx_fadeB", this.vfx_fadeB);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.setting_polygons = nbt.getBoolean("setting_polygons");
            this.chat_sprite = nbt.getString("chat_sprite");
            this.ftp_hunger = nbt.getDouble("ftp_hunger");
            this.ftp_playerLocation = nbt.getDouble("ftp_playerLocation");
            this.ftp_sanity = nbt.getDouble("ftp_sanity");
            this.ftp_sleep = nbt.getDouble("ftp_sleep");
            this.HomeX = nbt.getDouble("HomeX");
            this.HomeY = nbt.getDouble("HomeY");
            this.HomeZ = nbt.getDouble("HomeZ");
            this.player_blacksmith_level = nbt.getDouble("player_blacksmith_level");
            this.player_blacksmith_page = nbt.getDouble("player_blacksmith_page");
            this.player_blood = nbt.getBoolean("player_blood");
            this.player_bloodClock = nbt.getDouble("player_bloodClock");
            this.player_bloodKills = nbt.getDouble("player_bloodKills");
            this.player_bloodLustV = nbt.getBoolean("player_bloodLustV");
            this.player_camcorder = nbt.getBoolean("player_camcorder");
            this.player_end_quest = nbt.getDouble("player_end_quest");
            this.player_isGrabbing = nbt.getBoolean("player_isGrabbing");
            this.player_isThrowing = nbt.getBoolean("player_isThrowing");
            this.player_lastPlayed = nbt.getDouble("player_lastPlayed");
            this.player_name = nbt.getString("player_name");
            this.player_openShop = nbt.getDouble("player_openShop");
            this.player_questCommander = nbt.getDouble("player_questCommander");
            this.player_questEnderman = nbt.getBoolean("player_questEnderman");
            this.player_questLuna = nbt.getDouble("player_questLuna");
            this.player_questScott = nbt.getDouble("player_questScott");
            this.player_shards = nbt.getDouble("player_shards");
            this.player_statArmour = nbt.getDouble("player_statArmour");
            this.player_statAttack = nbt.getDouble("player_statAttack");
            this.player_statDefabricthasm = nbt.getDouble("player_statDefabricthasm");
            this.player_statRecovery = nbt.getDouble("player_statRecovery");
            this.player_statRegeneration = nbt.getDouble("player_statRegeneration");
            this.player_tooMuch = nbt.getBoolean("player_tooMuch");
            this.player_topsideTokens = nbt.getDouble("player_topsideTokens");
            this.player_translator = nbt.getBoolean("player_translator");
            this.player_typeArmour = nbt.getDouble("player_typeArmour");
            this.player_volumetrics = nbt.getBoolean("player_volumetrics");
            this.setting_camera = nbt.getBoolean("setting_camera");
            this.setting_effects = nbt.getDouble("setting_effects");
            this.setting_mod_sky = nbt.getBoolean("setting_mod_sky");
            this.vfx_fadeB = nbt.getDouble("vfx_fadeB");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "endertechinf_mapvars";
        public double ai_dncfEco = 0.0;
        public double ftp_corruption = 0.0;
        public double ftp_delta = 0.0;
        public double ftp_Download = 0.0;
        public boolean ftp_Downloaded = false;
        public boolean ftp_drain = false;
        public double ftp_inaccuracy = 0.0;
        public double ftp_lock_x = 0.0;
        public double ftp_lock_z = 0.0;
        public boolean ftp_lockdown = false;
        public double ftp_mannequin = 0.0;
        public double ftp_ongoingEvent = 0.0;
        public boolean ftp_placed = false;
        public boolean ftp_power = false;
        public boolean ftp_qualityDownload = false;
        public double ftp_randomN = 0.0;
        public double ftp_randomX = 0.0;
        public double ftp_randomZ = 0.0;
        public double ftp_shopPage = 1.0;
        public double ftp_zoomMultiplier = 1.0;
        public double story_ftp = 0.0;
        public double vfx_eastnyolPlane = 0.0;
        public boolean world_cityPortal = false;
        public double world_clockCity = 0.0;
        public double world_clockEnd = 0.0;
        public double world_clockServer = 0.0;
        public boolean world_genSchool = false;
        public double world_lastPlayed = 0.0;
        public double world_satelliteRotation = 0.0;
        public double world_satelliteRotationTarget = 0.0;
        public double world_seed = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.ai_dncfEco = nbt.getDouble("ai_dncfEco");
            this.ftp_corruption = nbt.getDouble("ftp_corruption");
            this.ftp_delta = nbt.getDouble("ftp_delta");
            this.ftp_Download = nbt.getDouble("ftp_Download");
            this.ftp_Downloaded = nbt.getBoolean("ftp_Downloaded");
            this.ftp_drain = nbt.getBoolean("ftp_drain");
            this.ftp_inaccuracy = nbt.getDouble("ftp_inaccuracy");
            this.ftp_lock_x = nbt.getDouble("ftp_lock_x");
            this.ftp_lock_z = nbt.getDouble("ftp_lock_z");
            this.ftp_lockdown = nbt.getBoolean("ftp_lockdown");
            this.ftp_mannequin = nbt.getDouble("ftp_mannequin");
            this.ftp_ongoingEvent = nbt.getDouble("ftp_ongoingEvent");
            this.ftp_placed = nbt.getBoolean("ftp_placed");
            this.ftp_power = nbt.getBoolean("ftp_power");
            this.ftp_qualityDownload = nbt.getBoolean("ftp_qualityDownload");
            this.ftp_randomN = nbt.getDouble("ftp_randomN");
            this.ftp_randomX = nbt.getDouble("ftp_randomX");
            this.ftp_randomZ = nbt.getDouble("ftp_randomZ");
            this.ftp_shopPage = nbt.getDouble("ftp_shopPage");
            this.ftp_zoomMultiplier = nbt.getDouble("ftp_zoomMultiplier");
            this.story_ftp = nbt.getDouble("story_ftp");
            this.vfx_eastnyolPlane = nbt.getDouble("vfx_eastnyolPlane");
            this.world_cityPortal = nbt.getBoolean("world_cityPortal");
            this.world_clockCity = nbt.getDouble("world_clockCity");
            this.world_clockEnd = nbt.getDouble("world_clockEnd");
            this.world_clockServer = nbt.getDouble("world_clockServer");
            this.world_genSchool = nbt.getBoolean("world_genSchool");
            this.world_lastPlayed = nbt.getDouble("world_lastPlayed");
            this.world_satelliteRotation = nbt.getDouble("world_satelliteRotation");
            this.world_satelliteRotationTarget = nbt.getDouble("world_satelliteRotationTarget");
            this.world_seed = nbt.getDouble("world_seed");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("ai_dncfEco", this.ai_dncfEco);
            nbt.putDouble("ftp_corruption", this.ftp_corruption);
            nbt.putDouble("ftp_delta", this.ftp_delta);
            nbt.putDouble("ftp_Download", this.ftp_Download);
            nbt.putBoolean("ftp_Downloaded", this.ftp_Downloaded);
            nbt.putBoolean("ftp_drain", this.ftp_drain);
            nbt.putDouble("ftp_inaccuracy", this.ftp_inaccuracy);
            nbt.putDouble("ftp_lock_x", this.ftp_lock_x);
            nbt.putDouble("ftp_lock_z", this.ftp_lock_z);
            nbt.putBoolean("ftp_lockdown", this.ftp_lockdown);
            nbt.putDouble("ftp_mannequin", this.ftp_mannequin);
            nbt.putDouble("ftp_ongoingEvent", this.ftp_ongoingEvent);
            nbt.putBoolean("ftp_placed", this.ftp_placed);
            nbt.putBoolean("ftp_power", this.ftp_power);
            nbt.putBoolean("ftp_qualityDownload", this.ftp_qualityDownload);
            nbt.putDouble("ftp_randomN", this.ftp_randomN);
            nbt.putDouble("ftp_randomX", this.ftp_randomX);
            nbt.putDouble("ftp_randomZ", this.ftp_randomZ);
            nbt.putDouble("ftp_shopPage", this.ftp_shopPage);
            nbt.putDouble("ftp_zoomMultiplier", this.ftp_zoomMultiplier);
            nbt.putDouble("story_ftp", this.story_ftp);
            nbt.putDouble("vfx_eastnyolPlane", this.vfx_eastnyolPlane);
            nbt.putBoolean("world_cityPortal", this.world_cityPortal);
            nbt.putDouble("world_clockCity", this.world_clockCity);
            nbt.putDouble("world_clockEnd", this.world_clockEnd);
            nbt.putDouble("world_clockServer", this.world_clockServer);
            nbt.putBoolean("world_genSchool", this.world_genSchool);
            nbt.putDouble("world_lastPlayed", this.world_lastPlayed);
            nbt.putDouble("world_satelliteRotation", this.world_satelliteRotation);
            nbt.putDouble("world_satelliteRotationTarget", this.world_satelliteRotationTarget);
            nbt.putDouble("world_seed", this.world_seed);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "endertechinf_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.chat_sprite = original.chat_sprite;
            clone.ftp_hunger = original.ftp_hunger;
            clone.ftp_playerLocation = original.ftp_playerLocation;
            clone.ftp_sanity = original.ftp_sanity;
            clone.ftp_sleep = original.ftp_sleep;
            clone.HomeX = original.HomeX;
            clone.HomeY = original.HomeY;
            clone.HomeZ = original.HomeZ;
            clone.player_blacksmith_level = original.player_blacksmith_level;
            clone.player_blacksmith_page = original.player_blacksmith_page;
            clone.player_blood = original.player_blood;
            clone.player_bloodClock = original.player_bloodClock;
            clone.player_bloodKills = original.player_bloodKills;
            clone.player_bloodLustV = original.player_bloodLustV;
            clone.player_camcorder = original.player_camcorder;
            clone.player_end_quest = original.player_end_quest;
            clone.player_isGrabbing = original.player_isGrabbing;
            clone.player_isThrowing = original.player_isThrowing;
            clone.player_lastPlayed = original.player_lastPlayed;
            clone.player_name = original.player_name;
            clone.player_openShop = original.player_openShop;
            clone.player_questCommander = original.player_questCommander;
            clone.player_questEnderman = original.player_questEnderman;
            clone.player_questLuna = original.player_questLuna;
            clone.player_questScott = original.player_questScott;
            clone.player_shards = original.player_shards;
            clone.player_statArmour = original.player_statArmour;
            clone.player_statAttack = original.player_statAttack;
            clone.player_statDefabricthasm = original.player_statDefabricthasm;
            clone.player_statRecovery = original.player_statRecovery;
            clone.player_statRegeneration = original.player_statRegeneration;
            clone.player_tooMuch = original.player_tooMuch;
            clone.player_topsideTokens = original.player_topsideTokens;
            clone.player_translator = original.player_translator;
            clone.player_typeArmour = original.player_typeArmour;
            clone.player_volumetrics = original.player_volumetrics;
            clone.setting_camera = original.setting_camera;
            clone.setting_effects = original.setting_effects;
            clone.setting_mod_sky = original.setting_mod_sky;
            clone.vfx_fadeB = original.vfx_fadeB;
            if (!event.isWasDeath()) {
                clone.setting_polygons = original.setting_polygons;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

