/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.init;

import eu.rxey.inf.potion.BefuddledMobEffect;
import eu.rxey.inf.potion.BiohazardInfestationMobEffect;
import eu.rxey.inf.potion.BloodlustMobEffect;
import eu.rxey.inf.potion.CooldownMobEffect;
import eu.rxey.inf.potion.DreadfallingMobEffect;
import eu.rxey.inf.potion.ElectrostaticFieldMobEffect;
import eu.rxey.inf.potion.ExhaustionMobEffect;
import eu.rxey.inf.potion.FadingInventoryMobEffect;
import eu.rxey.inf.potion.ObsidianAnklesMobEffect;
import eu.rxey.inf.potion.ParryReceiveMobEffect;
import eu.rxey.inf.potion.ParrySendMobEffect;
import eu.rxey.inf.potion.SingularityMobEffect;
import eu.rxey.inf.potion.TeleportingMobEffect;
import eu.rxey.inf.procedures.CooldownEffectExpiresProcedure;
import eu.rxey.inf.procedures.ElectrostaticFieldEffectExpiresProcedure;
import eu.rxey.inf.procedures.TeleportingEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class EndertechinfModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"endertechinf");
    public static final DeferredHolder<MobEffect, MobEffect> EXHAUSTION = REGISTRY.register("exhaustion", () -> new ExhaustionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ELECTROSTATIC_FIELD = REGISTRY.register("electrostatic_field", () -> new ElectrostaticFieldMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> COOLDOWN = REGISTRY.register("cooldown", () -> new CooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PARRY_SEND = REGISTRY.register("parry_send", () -> new ParrySendMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> PARRY_RECEIVE = REGISTRY.register("parry_receive", () -> new ParryReceiveMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BEFUDDLED = REGISTRY.register("befuddled", () -> new BefuddledMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> OBSIDIAN_ANKLES = REGISTRY.register("obsidian_ankles", () -> new ObsidianAnklesMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BIOHAZARD_INFESTATION = REGISTRY.register("biohazard_infestation", () -> new BiohazardInfestationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SINGULARITY = REGISTRY.register("singularity", () -> new SingularityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DREADFALLING = REGISTRY.register("dreadfalling", () -> new DreadfallingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FADING_INVENTORY = REGISTRY.register("fading_inventory", () -> new FadingInventoryMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLOODLUST = REGISTRY.register("bloodlust", () -> new BloodlustMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TELEPORTING = REGISTRY.register("teleporting", () -> new TeleportingMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            EndertechinfModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            EndertechinfModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(ELECTROSTATIC_FIELD)) {
            ElectrostaticFieldEffectExpiresProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        } else if (effectInstance.getEffect().is(COOLDOWN)) {
            CooldownEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(TELEPORTING)) {
            TeleportingEffectExpiresProcedure.execute((LevelAccessor)entity.level(), entity);
        }
    }
}

