/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import eu.rxey.inf.init.EndertechinfModBlocks;
import eu.rxey.inf.network.EndertechinfModVariables;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class GlowbarGlowProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        GlowbarGlowProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                GlowbarGlowProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    GlowbarGlowProcedure.mode = mode;
                    GlowbarGlowProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    GlowbarGlowProcedure.mode = mode;
                    GlowbarGlowProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        GlowbarGlowProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            GlowbarGlowProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            GlowbarGlowProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            GlowbarGlowProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlowbarGlowProcedure.execute((Event)event, (LevelAccessor)level, pos.x(), pos.y(), pos.z(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        GlowbarGlowProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        boolean found = false;
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        double count = 0.0;
        if (!((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).player_volumetrics) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (GlowbarGlowProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, false)) {
            GlowbarGlowProcedure.add(0.5f, 0.5f, 0.5f, -1061109568);
            GlowbarGlowProcedure.add(0.5f, 0.5f, -0.5f, -1061109568);
            GlowbarGlowProcedure.add(-0.5f, 0.5f, -0.5f, -1061109568);
            GlowbarGlowProcedure.add(-0.5f, 0.5f, 0.5f, -1061109568);
            GlowbarGlowProcedure.add(0.5f, 0.5f, -0.5f, -1061109568);
            GlowbarGlowProcedure.add(2.0f, -3.0f, -2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(-2.0f, -3.0f, -2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(-0.5f, 0.5f, -0.5f, -1061109568);
            GlowbarGlowProcedure.add(-0.5f, 0.5f, 0.5f, -1061109568);
            GlowbarGlowProcedure.add(-2.0f, -3.0f, 2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(2.0f, -3.0f, 2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(0.5f, 0.5f, 0.5f, -1061109568);
            GlowbarGlowProcedure.add(0.5f, 0.5f, 0.5f, -1061109568);
            GlowbarGlowProcedure.add(2.0f, -3.0f, 2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(2.0f, -3.0f, -2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(0.5f, 0.5f, -0.5f, -1061109568);
            GlowbarGlowProcedure.add(-0.5f, 0.5f, -0.5f, -1061109568);
            GlowbarGlowProcedure.add(-2.0f, -3.0f, -2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(-2.0f, -3.0f, 2.0f, 0xC0C0C0);
            GlowbarGlowProcedure.add(-0.5f, 0.5f, 0.5f, -1061109568);
            GlowbarGlowProcedure.end();
        }
        if (GlowbarGlowProcedure.target(2)) {
            sx = -12.0;
            for (int index0 = 0; index0 < 24; ++index0) {
                sy = -2.0;
                for (int index1 = 0; index1 < 10; ++index1) {
                    sz = -12.0;
                    for (int index2 = 0; index2 < 24; ++index2) {
                        if (world.getBlockState(BlockPos.containing((double)(Math.floor(x) + sx), (double)(Math.floor(y) + sy), (double)(Math.floor(z) + sz))).getBlock() == EndertechinfModBlocks.GLOWBAR.get()) {
                            int n;
                            Property property = world.getBlockState(BlockPos.containing((double)(Math.floor(x) + sx), (double)(Math.floor(y) + sy), (double)(Math.floor(z) + sz))).getBlock().getStateDefinition().getProperty("blockstate");
                            if (property instanceof IntegerProperty) {
                                IntegerProperty _getip46 = (IntegerProperty)property;
                                n = (Integer)world.getBlockState(BlockPos.containing((double)(Math.floor(x) + sx), (double)(Math.floor(y) + sy), (double)(Math.floor(z) + sz))).getValue((Property)_getip46);
                            } else {
                                n = -1;
                            }
                            if (n == 0) {
                                GlowbarGlowProcedure.renderShape(GlowbarGlowProcedure.shape(), Math.floor(x) + sx + 0.5, Math.floor(y) + sy + 0.3, Math.floor(z) + sz + 0.5, 0.0f, 0.0f, 0.0f, 0.99f, 0.99f, 0.99f, (int)(64L - Math.round(Math.max(Math.abs(sx), Math.abs(sz)) * 4.0)) << 24 | 0xFF0000 | 0xFF00 | 0xFF);
                                boolean bl = found = (count += 1.0) > 16.0;
                            }
                        }
                        if (found) break;
                        sz += 1.0;
                    }
                    if (found) break;
                    sy += 1.0;
                }
                if (found) break;
                sx += 1.0;
            }
            GlowbarGlowProcedure.release();
        }
    }
}

