/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import eu.rxey.inf.init.EndertechinfModScreens;
import eu.rxey.inf.network.RadioGUIButtonMessage;
import eu.rxey.inf.world.inventory.RadioGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class RadioGUIScreen
extends AbstractContainerScreen<RadioGUIMenu>
implements EndertechinfModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox valueCall;
    private ImageButton imagebutton_gui_desktop_button_a;
    private ImageButton imagebutton_gui_desktop_minus;

    public RadioGUIScreen(RadioGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("valueCall")) {
                this.valueCall.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.valueCall.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.valueCall.isFocused()) {
            return this.valueCall.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String valueCallValue = this.valueCall.getValue();
        super.resize(minecraft, width, height);
        this.valueCall.setValue(valueCallValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
        this.valueCall = new EditBox(this.font, this.leftPos + 28, this.topPos + 104, 118, 18, (Component)Component.translatable((String)"gui.endertechinf.radio_gui.valueCall"));
        this.valueCall.setMaxLength(8192);
        this.valueCall.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((RadioGUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "valueCall", content, false);
            }
        });
        this.valueCall.setHint((Component)Component.translatable((String)"gui.endertechinf.radio_gui.valueCall"));
        this.addWidget((GuiEventListener)this.valueCall);
        this.imagebutton_gui_desktop_button_a = new ImageButton(this, this.leftPos + 27, this.topPos + 130, 80, 24, new WidgetSprites(ResourceLocation.parse((String)"endertechinf:textures/screens/gui_desktop_button_a.png"), ResourceLocation.parse((String)"endertechinf:textures/screens/gui_desktop_button_a_hover.png")), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new RadioGUIButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            RadioGUIButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.imagebutton_gui_desktop_button_a);
        this.imagebutton_gui_desktop_minus = new ImageButton(this, this.leftPos + 115, this.topPos + 130, 32, 32, new WidgetSprites(ResourceLocation.parse((String)"endertechinf:textures/screens/gui_desktop_minus.png"), ResourceLocation.parse((String)"endertechinf:textures/screens/gui_desktop_minus_hover.png")), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new RadioGUIButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            RadioGUIButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.imagebutton_gui_desktop_minus);
    }
}

