/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import eu.rxey.inf.block.entity.NeutronicDrillBlockEntity;
import eu.rxey.inf.client.model.Modelroxy_drill;
import eu.rxey.inf.client.model.animations.roxy_drillAnimation;
import eu.rxey.inf.init.EndertechinfModBlockEntities;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class NeutronicDrillRenderer
implements BlockEntityRenderer<NeutronicDrillBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;

    NeutronicDrillRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelroxy_drill.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"endertechinf:textures/block/roxy_drill.png");
    }

    private void updateRenderState(NeutronicDrillBlockEntity blockEntity) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        blockEntity.animationState0.animateWhen(true, tickCount);
    }

    public void render(NeutronicDrillBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, (float)blockEntity.getLevel().getGameTime() + partialTick);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)EndertechinfModBlockEntities.NEUTRONIC_DRILL.get(), NeutronicDrillRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelroxy_drill {
        private final ModelPart root;
        private final BlockEntityHierarchicalModel animator = new BlockEntityHierarchicalModel();

        public CustomHierarchicalModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupBlockEntityAnim(NeutronicDrillBlockEntity blockEntity, float ageInTicks) {
            this.animator.setupBlockEntityAnim(blockEntity, ageInTicks);
            super.setupAnim(null, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        }

        private class BlockEntityHierarchicalModel
        extends HierarchicalModel<Entity> {
            private BlockEntityHierarchicalModel() {
            }

            public ModelPart root() {
                return CustomHierarchicalModel.this.root;
            }

            public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            }

            public void setupBlockEntityAnim(NeutronicDrillBlockEntity blockEntity, float ageInTicks) {
                CustomHierarchicalModel.this.animator.root().getAllParts().forEach(ModelPart::resetPose);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState0, roxy_drillAnimation.idle, ageInTicks, 1.0f);
            }
        }
    }
}

