/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.network;

import eu.rxey.inf.EndertechinfMod;
import eu.rxey.inf.procedures.DecreaseXCProcedure;
import eu.rxey.inf.procedures.DecreaseYCProcedure;
import eu.rxey.inf.procedures.DecreaseZCProcedure;
import eu.rxey.inf.procedures.IncreaseXCProcedure;
import eu.rxey.inf.procedures.IncreaseYCProcedure;
import eu.rxey.inf.procedures.IncreaseZCProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record CoordinatorGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CoordinatorGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"endertechinf", (String)"coordinator_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CoordinatorGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CoordinatorGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CoordinatorGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CoordinatorGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> CoordinatorGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            IncreaseXCProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            IncreaseYCProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            DecreaseXCProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            DecreaseYCProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            DecreaseZCProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            IncreaseZCProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EndertechinfMod.addNetworkMessage(TYPE, STREAM_CODEC, CoordinatorGUIButtonMessage::handleData);
    }
}

