/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.network;

import eu.rxey.inf.EndertechinfMod;
import eu.rxey.inf.procedures.FTPDownloadStartProcedure;
import eu.rxey.inf.procedures.FTPPlaySoundProcedure;
import eu.rxey.inf.procedures.FTPQualityDownloadStartProcedure;
import eu.rxey.inf.procedures.FTPSellDataProcedure;
import eu.rxey.inf.procedures.FTPStopSoundProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record SatelliteDownloadGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SatelliteDownloadGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"endertechinf", (String)"satellite_download_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SatelliteDownloadGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SatelliteDownloadGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SatelliteDownloadGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SatelliteDownloadGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> SatelliteDownloadGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            FTPDownloadStartProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            FTPPlaySoundProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            FTPStopSoundProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            FTPSellDataProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            FTPQualityDownloadStartProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EndertechinfMod.addNetworkMessage(TYPE, STREAM_CODEC, SatelliteDownloadGUIButtonMessage::handleData);
    }
}

