/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import eu.rxey.inf.network.EndertechinfModVariables;
import eu.rxey.inf.procedures.HasSatelliteDishProcedure;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RxShapesProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RxShapesProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RxShapesProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RxShapesProcedure.mode = mode;
                    RxShapesProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RxShapesProcedure.mode = mode;
                    RxShapesProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RxShapesProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RxShapesProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RxShapesProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RxShapesProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RxShapesProcedure.execute((Event)event, (LevelAccessor)level, pos.x(), pos.z(), (ResourceKey<Level>)level.dimension(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double z, ResourceKey<Level> dimension, Entity entity) {
        RxShapesProcedure.execute(null, world, x, z, dimension, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double z, ResourceKey<Level> dimension, Entity entity) {
        if (dimension == null || entity == null) {
            return;
        }
        boolean mkFound = false;
        double offset = 0.0;
        double i = 0.0;
        double j = 0.0;
        double k = 0.0;
        double l = 0.0;
        double uv = 0.0;
        double uvx = 0.0;
        double layer = 0.0;
        double loopX = 0.0;
        double slop = 0.0;
        double mkY = 0.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (!((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).setting_mod_sky) {
            return;
        }
        if (entity.getPersistentData().getDouble("vfxL") > 40.0) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (RxShapesProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                RxShapesProcedure.add(0.5f, -0.5f, -0.5f, -6250336);
                RxShapesProcedure.add(0.5f, -0.5f, 0.5f, -6250336);
                RxShapesProcedure.add(-0.5f, -0.5f, 0.5f, -6250336);
                RxShapesProcedure.add(-0.5f, -0.5f, -0.5f, -6250336);
                RxShapesProcedure.add(0.5f, 0.5f, 0.5f, -1);
                RxShapesProcedure.add(0.5f, 0.5f, -0.5f, -1);
                RxShapesProcedure.add(-0.5f, 0.5f, -0.5f, -1);
                RxShapesProcedure.add(-0.5f, 0.5f, 0.5f, -1);
                RxShapesProcedure.add(0.5f, 0.5f, -0.5f, -2039584);
                RxShapesProcedure.add(0.5f, -0.5f, -0.5f, -2039584);
                RxShapesProcedure.add(-0.5f, -0.5f, -0.5f, -2039584);
                RxShapesProcedure.add(-0.5f, 0.5f, -0.5f, -2039584);
                RxShapesProcedure.add(-0.5f, 0.5f, 0.5f, -2039584);
                RxShapesProcedure.add(-0.5f, -0.5f, 0.5f, -2039584);
                RxShapesProcedure.add(0.5f, -0.5f, 0.5f, -2039584);
                RxShapesProcedure.add(0.5f, 0.5f, 0.5f, -2039584);
                RxShapesProcedure.add(0.5f, 0.5f, 0.5f, -4144960);
                RxShapesProcedure.add(0.5f, -0.5f, 0.5f, -4144960);
                RxShapesProcedure.add(0.5f, -0.5f, -0.5f, -4144960);
                RxShapesProcedure.add(0.5f, 0.5f, -0.5f, -4144960);
                RxShapesProcedure.add(-0.5f, 0.5f, -0.5f, -4144960);
                RxShapesProcedure.add(-0.5f, -0.5f, -0.5f, -4144960);
                RxShapesProcedure.add(-0.5f, -0.5f, 0.5f, -4144960);
                RxShapesProcedure.add(-0.5f, 0.5f, 0.5f, -4144960);
                RxShapesProcedure.end();
            }
            if (RxShapesProcedure.target(2)) {
                ResourceKey resourceKey;
                if (HasSatelliteDishProcedure.execute(entity)) {
                    for (int index0 = 0; index0 < 3; ++index0) {
                        RxShapesProcedure.renderShape(RxShapesProcedure.shape(), (slop -= 100.0) + Math.cos(Math.toRadians(EndertechinfModVariables.MapVariables.get((LevelAccessor)world).world_satelliteRotation)) * 22.0, 245.0, slop + Math.sin(Math.toRadians(EndertechinfModVariables.MapVariables.get((LevelAccessor)world).world_satelliteRotation)) * 22.0, 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, -65536);
                    }
                }
                if (world instanceof Level) {
                    Level _lvl = (Level)world;
                    resourceKey = _lvl.dimension();
                } else if (world instanceof WorldGenLevel) {
                    WorldGenLevel _wgl = (WorldGenLevel)world;
                    resourceKey = _wgl.getLevel().dimension();
                } else {
                    resourceKey = Level.OVERWORLD;
                }
                if (resourceKey == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm_topside"))) {
                    for (int index1 = 0; index1 < 20; ++index1) {
                        RxShapesProcedure.renderShape(RxShapesProcedure.shape(), 873.5 + loopX, 109.0, 1110.5, 0.0f, 0.0f, 0.0f, 0.4f, 0.02f, 0.2f, -65536);
                        RxShapesProcedure.renderShape(RxShapesProcedure.shape(), 873.5 + loopX, 109.0, 1101.5, 0.0f, 0.0f, 0.0f, 0.4f, 0.2f, 0.2f, -65536);
                        loopX += 10.0;
                    }
                }
                RxShapesProcedure.release();
            }
        }
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (dimension == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:western_nyoldarria")) || dimension == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:eastern_nyoldarria"))) {
            mkFound = true;
            mkY = 63.3;
            r = 255.0;
            g = 255.0;
            b = 255.0;
        }
        if (dimension == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm"))) {
            mkFound = true;
            mkY = 100.3;
        }
        if (dimension == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:cathflkopfhnisvhe"))) {
            mkFound = true;
            mkY = 50.3;
            r = 95.0;
            g = 144.0;
            b = 153.0;
        }
        if (!mkFound) {
            return;
        }
        if (RxShapesProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, false)) {
            RxShapesProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, 0x28FFFFFF);
            RxShapesProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, 0x28FFFFFF);
            RxShapesProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 0x28FFFFFF);
            RxShapesProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, 0x28FFFFFF);
            RxShapesProcedure.end();
        }
        if (RxShapesProcedure.target(2)) {
            for (int index2 = 0; index2 < 16; ++index2) {
                RxShapesProcedure.renderShape(RxShapesProcedure.shape(), x, mkY, z, 0.0f, 0.0f, 0.0f, 1024.0f, 1.0f, 1024.0f, dimension == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm")) ? 146359858 : 0x6000000 | (int)r << 16 | (int)g << 8 | (int)b);
                mkY += dimension == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:cathflkopfhnisvhe")) ? 4.0 : 0.2;
            }
            RxShapesProcedure.release();
        }
    }
}

