/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import eu.rxey.inf.network.EndertechinfModVariables;
import eu.rxey.inf.procedures.DimensionCanRainProcedure;
import eu.rxey.inf.procedures.DimensionCanSeeBlueStarProcedure;
import eu.rxey.inf.procedures.DimensionCanSeeCloudsProcedure;
import eu.rxey.inf.procedures.DimensionCanSeeStarfallProcedure;
import eu.rxey.inf.procedures.DimensionCanSeeStarsProcedure;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class RxeySkyProcedure {
    private static int ticks = 0;
    private static float partialTick = 0.0f;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static Runnable setupFog = null;
    private static VertexBuffer abyssBuffer = null;
    private static VertexBuffer deepSkyBuffer = null;
    private static VertexBuffer skyboxBuffer = null;
    private static VertexBuffer starBuffer = null;
    private static int amount = 0;
    private static int seed = 0;
    private static final Predicate<Object[]> PREDICATE = params -> {
        ticks = (Integer)params[1];
        partialTick = ((Float)params[2]).floatValue();
        projectionMatrix = (Matrix4f)params[5];
        setupFog = (Runnable)params[7];
        FogRenderer.levelFogColor();
        setupFog.run();
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (entity != null) {
            ClientLevel level = minecraft.level;
            Vec3 pos = entity.getPosition(partialTick);
            poseStack = new PoseStack();
            poseStack.mulPose((Matrix4f)params[3]);
            RxeySkyProcedure.execute(null, (LevelAccessor)level, pos.y(), entity, partialTick, ticks);
            return true;
        }
        return false;
    };

    public static void renderAbyss(int color, boolean constant) {
        boolean visible;
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = visible = minecraft.player.getEyePosition(partialTick).y() - minecraft.level.getLevelData().getHorizonHeight((LevelHeightAccessor)minecraft.level) < 0.0;
        if (visible || constant) {
            if (abyssBuffer == null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::getPositionShader);
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
                bufferBuilder.addVertex(0.0f, -16.0f, 0.0f);
                for (int i = 0; i <= 8; ++i) {
                    bufferBuilder.addVertex(-512.0f * Mth.cos((float)((float)i * 45.0f * ((float)Math.PI / 180))), -16.0f, 512.0f * Mth.sin((float)((float)i * 45.0f * ((float)Math.PI / 180))));
                }
                abyssBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                abyssBuffer.bind();
                abyssBuffer.upload(bufferBuilder.buildOrThrow());
            } else {
                abyssBuffer.bind();
            }
            poseStack.pushPose();
            poseStack.translate(0.0f, 12.0f, 0.0f);
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            abyssBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
            VertexBuffer.unbind();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }
    }

    public static void renderDeepSky(int color) {
        if (deepSkyBuffer == null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionShader);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
            bufferBuilder.addVertex(0.0f, 16.0f, 0.0f);
            for (int i = 0; i <= 8; ++i) {
                bufferBuilder.addVertex(512.0f * Mth.cos((float)(45.0f * (float)i * ((float)Math.PI / 180))), 16.0f, 512.0f * Mth.sin((float)(45.0f * (float)i * ((float)Math.PI / 180))));
            }
            deepSkyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            deepSkyBuffer.bind();
            deepSkyBuffer.upload(bufferBuilder.buildOrThrow());
        } else {
            deepSkyBuffer.bind();
        }
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        deepSkyBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderEndSky(float yaw, float pitch, float roll, int color, boolean constant) {
        boolean invisible;
        Minecraft minecraft = Minecraft.getInstance();
        Vec3 pos = minecraft.gameRenderer.getMainCamera().getPosition();
        boolean bl = invisible = minecraft.level.effects().isFoggyAt(Mth.floor((double)pos.x()), Mth.floor((double)pos.y())) || minecraft.gui.getBossOverlay().shouldCreateWorldFog();
        if (!invisible || constant) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
            poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
            poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
            Matrix4f matrix4f = poseStack.last().pose();
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            block8: for (int i = 0; i < 6; ++i) {
                switch (i) {
                    case 0: {
                        bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f);
                        bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f);
                        continue block8;
                    }
                    case 1: {
                        bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 0.0f);
                        bufferBuilder.addVertex(matrix4f, -100.0f, 100.0f, 100.0f).setUv(0.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, 100.0f, 100.0f).setUv(16.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 0.0f);
                        continue block8;
                    }
                    case 2: {
                        bufferBuilder.addVertex(matrix4f, -100.0f, 100.0f, -100.0f).setUv(0.0f, 0.0f);
                        bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, 100.0f, -100.0f).setUv(16.0f, 0.0f);
                        continue block8;
                    }
                    case 3: {
                        bufferBuilder.addVertex(matrix4f, -100.0f, 100.0f, 100.0f).setUv(0.0f, 0.0f);
                        bufferBuilder.addVertex(matrix4f, -100.0f, 100.0f, -100.0f).setUv(0.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, 100.0f, -100.0f).setUv(16.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, 100.0f, 100.0f).setUv(16.0f, 0.0f);
                        continue block8;
                    }
                    case 4: {
                        bufferBuilder.addVertex(matrix4f, -100.0f, 100.0f, -100.0f).setUv(0.0f, 0.0f);
                        bufferBuilder.addVertex(matrix4f, -100.0f, 100.0f, 100.0f).setUv(0.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f);
                        continue block8;
                    }
                    case 5: {
                        bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, 100.0f, 100.0f).setUv(16.0f, 16.0f);
                        bufferBuilder.addVertex(matrix4f, 100.0f, 100.0f, -100.0f).setUv(16.0f, 0.0f);
                    }
                }
            }
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }
    }

    public static void renderMoon(float size, int color, boolean phase, boolean constant) {
        ClientLevel level = Minecraft.getInstance().level;
        float r = size / 2.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        if (phase) {
            int i0 = level.getMoonPhase();
            int i1 = i0 & 3;
            int i2 = i0 >> 2 & 1;
            u0 = (float)i1 / 4.0f;
            v0 = (float)i2 / 2.0f;
            u1 = (float)(i1 + 1) / 4.0f;
            v1 = (float)(i2 + 1) / 2.0f;
        }
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - level.getRainLevel(partialTick);
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, -r, -100.0f, -r).setUv(u1, v1);
        bufferBuilder.addVertex(matrix4f, -r, -100.0f, r).setUv(u0, v1);
        bufferBuilder.addVertex(matrix4f, r, -100.0f, r).setUv(u0, v0);
        bufferBuilder.addVertex(matrix4f, r, -100.0f, -r).setUv(u1, v0);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderSky(boolean deepSky, boolean sunlights, boolean sun, boolean moon, boolean stars, boolean abyss) {
        Object color;
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (deepSky) {
            color = level.getSkyColor(minecraft.gameRenderer.getMainCamera().getPosition(), partialTick);
            RenderSystem.defaultBlendFunc();
            RxeySkyProcedure.renderDeepSky(0xFF000000 | (int)(color.x() * 255.0) << 16 | (int)(color.y() * 255.0) << 8 | (int)(color.z() * 255.0));
        }
        if (sunlights && (color = (Object)level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick)) != null) {
            RenderSystem.defaultBlendFunc();
            RxeySkyProcedure.renderSunlights((int)(color[3] * 255.0f) << 24 | (int)(color[0] * 255.0f) << 16 | (int)(color[1] * 255.0f) << 8 | (int)(color[2] * 255.0f));
        }
        if (sun) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png"));
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RxeySkyProcedure.renderSun(60.0f, -1, false);
        }
        if (moon) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png"));
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RxeySkyProcedure.renderMoon(40.0f, -1, true, false);
        }
        if (stars) {
            int color2 = (int)(level.getStarBrightness(partialTick) * 255.0f);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RxeySkyProcedure.renderStars(1500, 10842, 90.0f, level.getTimeOfDay(partialTick) * 360.0f, 0.0f, color2 << 24 | color2 << 16 | color2 << 8 | color2, false);
        }
        if (abyss) {
            RenderSystem.defaultBlendFunc();
            RxeySkyProcedure.renderAbyss(-16777216, false);
        }
    }

    public static void renderSkybox(float yaw, float pitch, float roll, int color, boolean constant) {
        boolean invisible;
        Minecraft minecraft = Minecraft.getInstance();
        Vec3 pos = minecraft.gameRenderer.getMainCamera().getPosition();
        boolean bl = invisible = minecraft.level.effects().isFoggyAt(Mth.floor((double)pos.x()), Mth.floor((double)pos.y())) || minecraft.gui.getBossOverlay().shouldCreateWorldFog();
        if (!invisible || constant) {
            if (skyboxBuffer == null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                block8: for (int i = 0; i < 6; ++i) {
                    switch (i) {
                        case 0: {
                            bufferBuilder.addVertex(-0.5f, -0.5f, -0.5f).setUv(0.0f, 0.0f);
                            bufferBuilder.addVertex(-0.5f, -0.5f, 0.5f).setUv(0.0f, 0.5f);
                            bufferBuilder.addVertex(0.5f, -0.5f, 0.5f).setUv(0.33333334f, 0.5f);
                            bufferBuilder.addVertex(0.5f, -0.5f, -0.5f).setUv(0.33333334f, 0.0f);
                            continue block8;
                        }
                        case 1: {
                            bufferBuilder.addVertex(-0.5f, 0.5f, 0.5f).setUv(0.33333334f, 0.0f);
                            bufferBuilder.addVertex(-0.5f, 0.5f, -0.5f).setUv(0.33333334f, 0.5f);
                            bufferBuilder.addVertex(0.5f, 0.5f, -0.5f).setUv(0.6666667f, 0.5f);
                            bufferBuilder.addVertex(0.5f, 0.5f, 0.5f).setUv(0.6666667f, 0.0f);
                            continue block8;
                        }
                        case 2: {
                            bufferBuilder.addVertex(0.5f, 0.5f, 0.5f).setUv(0.6666667f, 0.0f);
                            bufferBuilder.addVertex(0.5f, -0.5f, 0.5f).setUv(0.6666667f, 0.5f);
                            bufferBuilder.addVertex(-0.5f, -0.5f, 0.5f).setUv(1.0f, 0.5f);
                            bufferBuilder.addVertex(-0.5f, 0.5f, 0.5f).setUv(1.0f, 0.0f);
                            continue block8;
                        }
                        case 3: {
                            bufferBuilder.addVertex(-0.5f, 0.5f, 0.5f).setUv(0.0f, 0.5f);
                            bufferBuilder.addVertex(-0.5f, -0.5f, 0.5f).setUv(0.0f, 1.0f);
                            bufferBuilder.addVertex(-0.5f, -0.5f, -0.5f).setUv(0.33333334f, 1.0f);
                            bufferBuilder.addVertex(-0.5f, 0.5f, -0.5f).setUv(0.33333334f, 0.5f);
                            continue block8;
                        }
                        case 4: {
                            bufferBuilder.addVertex(-0.5f, 0.5f, -0.5f).setUv(0.33333334f, 0.5f);
                            bufferBuilder.addVertex(-0.5f, -0.5f, -0.5f).setUv(0.33333334f, 1.0f);
                            bufferBuilder.addVertex(0.5f, -0.5f, -0.5f).setUv(0.6666667f, 1.0f);
                            bufferBuilder.addVertex(0.5f, 0.5f, -0.5f).setUv(0.6666667f, 0.5f);
                            continue block8;
                        }
                        case 5: {
                            bufferBuilder.addVertex(0.5f, 0.5f, -0.5f).setUv(0.6666667f, 0.5f);
                            bufferBuilder.addVertex(0.5f, -0.5f, -0.5f).setUv(0.6666667f, 1.0f);
                            bufferBuilder.addVertex(0.5f, -0.5f, 0.5f).setUv(1.0f, 1.0f);
                            bufferBuilder.addVertex(0.5f, 0.5f, 0.5f).setUv(1.0f, 0.5f);
                        }
                    }
                }
                skyboxBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                skyboxBuffer.bind();
                skyboxBuffer.upload(bufferBuilder.buildOrThrow());
            } else {
                skyboxBuffer.bind();
            }
            float size = minecraft.options.getEffectiveRenderDistance() << 6;
            poseStack.pushPose();
            poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
            poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
            poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
            poseStack.scale(size, size, size);
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            skyboxBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionTexShader());
            VertexBuffer.unbind();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }
    }

    public static void renderStars(int amount, int seed, float yaw, float pitch, float roll, int color, boolean constant) {
        if (starBuffer == null || amount != RxeySkyProcedure.amount || seed != RxeySkyProcedure.seed) {
            RxeySkyProcedure.amount = amount;
            RxeySkyProcedure.seed = seed;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionShader);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            RandomSource randomsource = RandomSource.create((long)seed);
            for (int i = 0; i < amount; ++i) {
                float f0 = randomsource.nextFloat() * 2.0f - 1.0f;
                float f1 = randomsource.nextFloat() * 2.0f - 1.0f;
                float f2 = randomsource.nextFloat() * 2.0f - 1.0f;
                float f3 = 0.15f + 0.1f * randomsource.nextFloat();
                float f4 = f0 * f0 + f1 * f1 + f2 * f2;
                if (!(f4 < 1.0f) || !(f4 > 0.01f)) continue;
                f4 = 1.0f / Mth.sqrt((float)f4);
                float f5 = (f0 *= f4) * 100.0f;
                float f6 = (f1 *= f4) * 100.0f;
                float f7 = (f2 *= f4) * 100.0f;
                float f8 = (float)Math.atan2(f0, f2);
                float f9 = Mth.sin((float)f8);
                float f10 = Mth.cos((float)f8);
                float f11 = (float)Math.atan2(Mth.sqrt((float)(f0 * f0 + f2 * f2)), f1);
                float f12 = Mth.sin((float)f11);
                float f13 = Mth.cos((float)f11);
                float f14 = (float)randomsource.nextDouble() * (float)Math.PI * 2.0f;
                float f15 = Mth.sin((float)f14);
                float f16 = Mth.cos((float)f14);
                for (int j = 0; j < 4; ++j) {
                    float f17 = (float)((j & 2) - 1) * f3;
                    float f18 = (float)((j + 1 & 2) - 1) * f3;
                    float f20 = f17 * f16 - f18 * f15;
                    float f21 = f18 * f16 + f17 * f15;
                    float f22 = -f20 * f13;
                    float f23 = f22 * f9 - f21 * f10;
                    float f24 = f20 * f12;
                    float f25 = f21 * f9 + f22 * f10;
                    bufferBuilder.addVertex(f5 + f23, f6 + f24, f7 + f25);
                }
            }
            if (starBuffer != null) {
                starBuffer.close();
            }
            starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            starBuffer.bind();
            starBuffer.upload(bufferBuilder.buildOrThrow());
        } else {
            starBuffer.bind();
        }
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.getInstance().level.getRainLevel(partialTick);
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        FogRenderer.setupNoFog();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        starBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        setupFog.run();
        poseStack.popPose();
    }

    public static void renderSun(float size, int color, boolean constant) {
        ClientLevel level = Minecraft.getInstance().level;
        float r = size / 2.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - level.getRainLevel(partialTick);
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, r, 100.0f, -r).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, r, 100.0f, r).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, -r, 100.0f, r).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, -r, 100.0f, -r).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderSunlights(int color) {
        ClientLevel level = Minecraft.getInstance().level;
        float[] rawColor = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
        if (rawColor != null) {
            boolean flag;
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int alpha = (int)((float)(color >>> 24) * rawColor[3]);
            Matrix4f matrix4f = poseStack.last().pose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            boolean bl = flag = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f;
            if (flag) {
                bufferBuilder.addVertex(matrix4f, 100.0f, 0.0f, 0.0f).setColor(red, green, blue, alpha);
            } else {
                bufferBuilder.addVertex(matrix4f, -100.0f, 0.0f, 0.0f).setColor(red, green, blue, alpha);
            }
            for (int i = 0; i <= 16; ++i) {
                float deg = (float)i * ((float)Math.PI * 2) / 16.0f;
                float sin = Mth.sin((float)deg);
                float cos = Mth.cos((float)deg);
                if (flag) {
                    bufferBuilder.addVertex(matrix4f, cos * 120.0f, cos * 40.0f * rawColor[3], -sin * 120.0f).setColor(red, green, blue, 0);
                    continue;
                }
                bufferBuilder.addVertex(matrix4f, -cos * 120.0f, cos * 40.0f * rawColor[3], sin * 120.0f).setColor(red, green, blue, 0);
            }
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        }
    }

    public static void renderTexture(float size, float yaw, float pitch, float roll, int color, boolean constant) {
        float r = size / 2.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.getInstance().level.getRainLevel(partialTick);
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, r, r, 100.0f).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, r, -r, 100.0f).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, -r, -r, 100.0f).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, -r, r, 100.0f).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void skySetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_SKY").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute(LevelAccessor world, double y, Entity entity, double partialTick, double ticks) {
        RxeySkyProcedure.execute(null, world, y, entity, partialTick, ticks);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double y, Entity entity, double partialTick, double ticks) {
        if (entity == null) {
            return;
        }
        boolean hasNightStars = false;
        boolean hasStarfall = false;
        boolean hasBlueStar = false;
        boolean hasClouds = false;
        boolean hasWeather = false;
        String mID = "";
        String mSky = "";
        String planet = "";
        double atm_space = 0.0;
        double spin_star = 0.0;
        double cR = 0.0;
        double cG = 0.0;
        double cB = 0.0;
        double starfall = 0.0;
        double levelStar = 0.0;
        double levelStarAnti = 0.0;
        double halfTick = 0.0;
        if (!((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).setting_mod_sky) {
            return;
        }
        if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:deep_water_dimension")) && y < 299.0) {
            return;
        }
        hasWeather = DimensionCanRainProcedure.execute(world);
        hasNightStars = DimensionCanSeeStarsProcedure.execute(world);
        hasStarfall = DimensionCanSeeStarfallProcedure.execute(world);
        hasBlueStar = DimensionCanSeeBlueStarProcedure.execute(world);
        hasClouds = DimensionCanSeeCloudsProcedure.execute(world);
        spin_star = world.getTimeOfDay((float)partialTick) * 360.0f;
        levelStar = entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:outer_space")) ? 255.0 : Math.max((double)((world instanceof ClientLevel ? ((ClientLevel)world).getStarBrightness((float)partialTick) : 0.0f) * 2.0f * 255.0f), Math.min(255.0, y - 200.0));
        levelStarAnti = (1.0f - (world instanceof ClientLevel ? ((ClientLevel)world).getStarBrightness((float)partialTick) : 0.0f) * 2.0f) * 255.0f;
        halfTick = ticks * 0.5;
        atm_space = y > 200.0 ? Math.max(140.0 - (y - 200.0), 0.0) : 140.0;
        mID = "endertechinf";
        planet = "blank";
        if (hasNightStars) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)(mID + ":textures/skybox_nebula.png")));
            RxeySkyProcedure.renderSkybox((float)spin_star, (float)spin_star, 0.0f, (int)levelStar << 24 | 0xFF0000 | 0xFF00 | 0xFF, true);
            RxeySkyProcedure.renderStars(6000, 1, (float)spin_star, (float)spin_star, 0.0f, (int)levelStar << 24 | 0xEA0000 | 0xF000 | 0xFF, true);
        }
        mSky = "skybox_plagued";
        cR = 148.0;
        cG = 10.0;
        cB = 212.0;
        if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:western_nyoldarria"))) {
            planet = "gui_planet_nyoldarria";
            cR = 200.0;
            cG = 220.0;
            cB = 255.0;
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:eastern_nyoldarria"))) {
            planet = "gui_planet_nyoldarria";
            cR = 255.0;
            cG = 120.0;
            cB = 100.0;
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm"))) {
            mSky = "skybox_city";
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:concyderum"))) {
            planet = "gui_planet_concyderum";
            mSky = "skybox_concyderum";
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:pre_singularity"))) {
            planet = "skybox_galaxy";
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:sandworld"))) {
            planet = "gui_planet_sandworld";
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:deep_water_dimension"))) {
            planet = "gui_planet_anchoreanische";
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:plane_of_forgotten_souls"))) {
            planet = "gui_planet_dyschentya";
            cR = 255.0;
            cG = 0.0;
            cB = 0.0;
        } else if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm_topside"))) {
            mSky = "skybox_ftp_a";
            cR = 60.0;
            cG = 10.0;
            cB = 80.0;
        }
        if (!mSky.equals("skybox_plagued")) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)(mID + ":textures/" + mSky + ".png")));
            RxeySkyProcedure.renderSkybox(0.0f, entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:concyderum")) ? -45 : 0, -2.0f, (int)atm_space << 24 | (int)cR << 16 | (int)cG << 8 | (int)cB, true);
        }
        mSky = "skybox_plagued";
        if (world.dimensionType().moonPhase(world.dayTime()) == 4 && hasStarfall) {
            for (int index0 = 0; index0 < 20; ++index0) {
                RxeySkyProcedure.renderStars(300, 2, 8.0f, (float)(ticks + starfall), 8.0f, (int)Math.min(starfall * 20.0, levelStar) << 24 | 0xFF0000 | 0xFF00 | 0xFF, true);
                starfall += 0.3;
            }
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (hasBlueStar) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)(mID + ":textures/skybox_blue_star.png")));
            RxeySkyProcedure.renderTexture(32.0f, 45.0f, (float)(spin_star - 90.0), 0.0f, -1, true);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)(mID + ":textures/" + mSky + ".png")));
        RxeySkyProcedure.renderSkybox(0.0f, (float)halfTick, 0.0f, (int)atm_space << 24 | (int)cR << 16 | (int)cG << 8 | (int)cB, true);
        RxeySkyProcedure.renderSkybox((float)halfTick, 0.0f, 0.0f, (int)atm_space << 24 | (int)cR << 16 | (int)cG << 8 | (int)cB, true);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (hasClouds) {
            if (world.dimensionType().moonPhase(world.dayTime()) == 1) {
                RxeySkyProcedure.renderSkybox((float)halfTick, 0.0f, 0.0f, (int)Math.min(atm_space, levelStar) << 24 | 0xFF0000 | 0xFF00 | 0xFF, true);
                RxeySkyProcedure.renderSkybox(0.0f, (float)halfTick, 0.0f, (int)Math.min(atm_space, levelStar) << 24 | 0xFF0000 | 0xFF00 | 0xFF, true);
            }
            if (world.dimensionType().moonPhase(world.dayTime()) == 7) {
                RxeySkyProcedure.renderSkybox((float)halfTick, 0.0f, 0.0f, (int)Math.min(atm_space, levelStarAnti) << 24 | 0xFF0000 | 0xFF00 | 0xFF, true);
                RxeySkyProcedure.renderSkybox(0.0f, (float)halfTick, 0.0f, (int)Math.min(atm_space, levelStarAnti) << 24 | 0xFF0000 | 0xFF00 | 0xFF, true);
            }
        }
        if (hasWeather && entity.getPersistentData().getDouble("rainI") > 1.0) {
            RxeySkyProcedure.renderSkybox((float)halfTick, 0.0f, 0.0f, (int)(entity.getPersistentData().getDouble("rainI") * 10.0) << 24 | 0xC80000 | 0xC800 | 0xC8, true);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RxeySkyProcedure.renderSkybox(0.0f, 0.0f, 0.0f, (int)entity.getPersistentData().getDouble("vLight") << 24 | 0xFF0000 | 0x3200 | 0xFF, true);
            RxeySkyProcedure.renderSkybox(45.0f, 0.0f, 0.0f, (int)entity.getPersistentData().getDouble("vLight") << 24 | 0xFF0000 | 0x3200 | 0xFF, true);
        }
        if (entity.getPersistentData().getDouble("easeDread") > 2.0) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/skybox_dread.png"));
            starfall = 1.0;
            for (int index1 = 0; index1 < 3; ++index1) {
                RxeySkyProcedure.renderSkybox((float)(ticks * starfall), 0.0f, 0.0f, (int)Math.min(entity.getPersistentData().getDouble("easeDread"), 255.0) << 24 | 0xFF0000 | 0xFF00 | 0xFF, true);
                starfall -= 0.2;
            }
        }
        if (!planet.isEmpty()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)(mID + ":textures/" + planet + ".png")));
            RxeySkyProcedure.renderTexture((float)(entity.level().dimension() == Level.END ? 256.0 : 1024.0 / Math.abs(y) * 128.0), 0.0f, 90.0f, 0.0f, 0xFF000000 | (int)levelStarAnti << 16 | (int)levelStarAnti << 8 | (int)levelStarAnti, true);
        }
    }
}

