/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class VoidBrickGeneratorOnTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        if (VoidBrickGeneratorOnTickUpdateProcedure.getEnergyStored(world, BlockPos.containing((double)x, (double)y, (double)z), null) > 4096) {
            Level _level;
            if (!world.isClientSide()) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stone.break")), SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stone.break")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.deepslate_bricks.break")), SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.deepslate_bricks.break")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                }
            }
            while (VoidBrickGeneratorOnTickUpdateProcedure.getEnergyStored(world, BlockPos.containing((double)x, (double)y, (double)z), null) > 4096) {
                ItemEntity entityToSpawn;
                ILevelExtension _ext;
                IEnergyStorage _entityStorage;
                if (world instanceof ILevelExtension && (_entityStorage = (IEnergyStorage)(_ext = (ILevelExtension)world).getCapability(Capabilities.EnergyStorage.BLOCK, BlockPos.containing((double)x, (double)y, (double)z), null)) != null) {
                    _entityStorage.extractEnergy(4096, false);
                }
                if (VoidBrickGeneratorOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.NORTH) {
                    if (!(world instanceof ServerLevel)) continue;
                    _level = (ServerLevel)world;
                    entityToSpawn = new ItemEntity(_level, x, y, z + 1.2, new ItemStack((ItemLike)Items.BRICK));
                    entityToSpawn.setPickUpDelay(0);
                    _level.addFreshEntity((Entity)entityToSpawn);
                    continue;
                }
                if (VoidBrickGeneratorOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.SOUTH) {
                    if (!(world instanceof ServerLevel)) continue;
                    _level = (ServerLevel)world;
                    entityToSpawn = new ItemEntity(_level, x, y, z - 1.2, new ItemStack((ItemLike)Items.BRICK));
                    entityToSpawn.setPickUpDelay(0);
                    _level.addFreshEntity((Entity)entityToSpawn);
                    continue;
                }
                if (VoidBrickGeneratorOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.WEST) {
                    if (!(world instanceof ServerLevel)) continue;
                    _level = (ServerLevel)world;
                    entityToSpawn = new ItemEntity(_level, x - 1.2, y, z, new ItemStack((ItemLike)Items.BRICK));
                    entityToSpawn.setPickUpDelay(0);
                    _level.addFreshEntity((Entity)entityToSpawn);
                    continue;
                }
                if (VoidBrickGeneratorOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) != Direction.EAST || !(world instanceof ServerLevel)) continue;
                _level = (ServerLevel)world;
                entityToSpawn = new ItemEntity(_level, x + 1.2, y, z, new ItemStack((ItemLike)Items.BRICK));
                entityToSpawn.setPickUpDelay(0);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
        }
    }

    public static int getEnergyStored(LevelAccessor level, BlockPos pos, Direction direction) {
        ILevelExtension levelExtension;
        IEnergyStorage energyStorage;
        if (level instanceof ILevelExtension && (energyStorage = (IEnergyStorage)(levelExtension = (ILevelExtension)level).getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)direction)) != null) {
            return energyStorage.getEnergyStored();
        }
        return 0;
    }

    private static Direction getBlockDirection(LevelAccessor world, BlockPos pos) {
        Comparable comparable;
        BlockState blockState = world.getBlockState(pos);
        Property property = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (property != null && (comparable = blockState.getValue(property)) instanceof Direction) {
            Direction direction = (Direction)comparable;
            return direction;
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return Direction.NORTH;
    }
}

