/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.mixin;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class PlayerGravityMixin {
    private static final ResourceKey<Level> OUTER_SPACE = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"endertechinf", (String)"outer_space"));

    @Inject(method={"setDeltaMovement(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void freezeYMovementInSpace(double x, double y, double z, CallbackInfo ci) {
        Entity self = (Entity)this;
        Level level = self.level();
        if (level != null && level.dimension().equals(OUTER_SPACE)) {
            LivingEntity living;
            if (self instanceof LivingEntity && (living = (LivingEntity)self).isFallFlying()) {
                return;
            }
            self.setDeltaMovement(new Vec3(x, 0.0, z));
            ci.cancel();
        }
    }
}

