/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.network;

import eu.rxey.inf.EndertechinfMod;
import eu.rxey.inf.procedures.DesktopMinusAAProcedure;
import eu.rxey.inf.procedures.DesktopMinusAProcedure;
import eu.rxey.inf.procedures.DesktopMinusBBProcedure;
import eu.rxey.inf.procedures.DesktopMinusBProcedure;
import eu.rxey.inf.procedures.DesktopPlusAAProcedure;
import eu.rxey.inf.procedures.DesktopPlusAProcedure;
import eu.rxey.inf.procedures.DesktopPlusBBProcedure;
import eu.rxey.inf.procedures.DesktopPlusBProcedure;
import eu.rxey.inf.procedures.FTPZoomInProcedure;
import eu.rxey.inf.procedures.FTPZoomOutProcedure;
import eu.rxey.inf.procedures.SatelliteCoreLockProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record SatelliteCoreGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SatelliteCoreGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"endertechinf", (String)"satellite_core_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SatelliteCoreGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SatelliteCoreGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SatelliteCoreGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SatelliteCoreGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> SatelliteCoreGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            DesktopPlusAProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            DesktopPlusBProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            DesktopMinusAProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            DesktopMinusBProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            SatelliteCoreLockProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            DesktopPlusAAProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            DesktopPlusBBProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            DesktopMinusAAProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            DesktopMinusBBProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            FTPZoomInProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 11) {
            FTPZoomOutProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EndertechinfMod.addNetworkMessage(TYPE, STREAM_CODEC, SatelliteCoreGUIButtonMessage::handleData);
    }
}

