/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import eu.rxey.inf.init.EndertechinfModMobEffects;
import eu.rxey.inf.network.EndertechinfModVariables;
import eu.rxey.inf.procedures.LightCallProcedure;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ETcallPhysicsProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"rxey:ftp/light")))) {
            LightCallProcedure.execute(world, x, y, z);
        }
        if (world.isClientSide()) {
            return;
        }
        List playersNearby = world.getEntitiesOfClass(Player.class, new AABB(new Vec3(x, y, z), new Vec3(x, y, z)).inflate(4.0), p -> true);
        double volume = entity.getBbHeight() * entity.getBbWidth();
        double weightMultiplier = volume < 0.8 ? 1.0 : (double)(volume < 1.5 ? 2 : 4);
        double weight = Math.max(0.8, volume * 5.0);
        boolean found = false;
        String grabbedTarget = entity.getPersistentData().getString("grabbed");
        for (Player player : playersNearby) {
            EndertechinfModVariables.PlayerVariables vars = (EndertechinfModVariables.PlayerVariables)player.getData(EndertechinfModVariables.PLAYER_VARIABLES);
            if (!vars.player_isGrabbing || !player.getDisplayName().getString().equals(grabbedTarget)) continue;
            int zoom = player.getInventory().selected;
            double distance = 0.5 + (double)zoom / 4.0;
            Vec3 look = player.getLookAngle();
            double targetX = player.getX() + look.x * distance;
            double targetY = player.getY() + (double)player.getBbHeight() - 0.32 + look.y * distance;
            double targetZ = player.getZ() + look.z * distance;
            Vec3 velocity = new Vec3((targetX - x) / weight, (targetY - y) / weight, (targetZ - z) / weight);
            entity.setDeltaMovement(velocity);
            if (weightMultiplier != 1.0) {
                if (!player.level().isClientSide()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, (int)weightMultiplier, false, false));
                }
            } else if (vars.player_isThrowing && !player.hasEffect(EndertechinfModMobEffects.COOLDOWN)) {
                if (!player.level().isClientSide()) {
                    player.addEffect(new MobEffectInstance(EndertechinfModMobEffects.COOLDOWN, 20, 0, false, false));
                }
                entity.push(look.x * distance, look.y * distance, look.z * distance);
                entity.getPersistentData().putString("grabbed", "");
                if (world instanceof Level) {
                    Level lvl = (Level)world;
                    float pitch = 0.8f + lvl.getRandom().nextFloat() * 0.4f;
                    if (!lvl.isClientSide()) {
                        lvl.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"endertechinf:sfx_throw")), SoundSource.PLAYERS, 0.8f, pitch);
                    } else {
                        lvl.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"endertechinf:sfx_throw")), SoundSource.PLAYERS, 0.8f, pitch, false);
                    }
                }
                entity.setNoGravity(false);
            }
            Entity e = entity;
            e.setYRot(player.getYRot() + 180.0f);
            e.setXRot(0.0f);
            e.setYBodyRot(e.getYRot());
            e.setYHeadRot(e.getYRot());
            e.yRotO = e.getYRot();
            e.xRotO = e.getXRot();
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                le.yBodyRotO = le.getYRot();
                le.yHeadRotO = le.getYRot();
            }
            found = true;
            entity.setNoGravity(true);
            entity.fallDistance = 0.0f;
            break;
        }
        if (!found) {
            if (!grabbedTarget.isEmpty()) {
                entity.getPersistentData().putString("grabbed", "");
            }
            entity.setNoGravity(false);
        }
    }
}

