/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import eu.rxey.inf.network.EndertechinfModVariables;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class NewRenderProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        NewRenderProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                NewRenderProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    NewRenderProcedure.mode = mode;
                    NewRenderProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    NewRenderProcedure.mode = mode;
                    NewRenderProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        NewRenderProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            NewRenderProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            NewRenderProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            NewRenderProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            NewRenderProcedure.execute((Event)event, pos.x(), pos.y(), pos.z(), (ResourceKey<Level>)level.dimension(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(double x, double y, double z, ResourceKey<Level> dimension, Entity entity) {
        NewRenderProcedure.execute(null, x, y, z, dimension, entity);
    }

    private static void execute(@Nullable Event event, double x, double y, double z, ResourceKey<Level> dimension, Entity entity) {
        float v4;
        float u4;
        float v3;
        float u3;
        float v2;
        float u2;
        float v1;
        float u1;
        float z4;
        float x4;
        float z3;
        float x3;
        float z2;
        float x2;
        float z1;
        float x1;
        float phi2;
        if (dimension == null || entity == null) {
            return;
        }
        double resolutionA = 0.0;
        double resolutionB = 0.0;
        double sum = 0.0;
        double loop1 = 0.0;
        double ray = 0.0;
        if (dimension != ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:outer_space"))) {
            return;
        }
        if (!((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).setting_mod_sky) {
            return;
        }
        if (((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).setting_polygons) {
            resolutionA = 64.0;
            resolutionB = 32.0;
            sum = x + y + z;
        } else {
            resolutionA = 12.0;
            resolutionB = 12.0;
        }
        NewRenderProcedure.system(true);
        int slices = (int)resolutionA;
        int stacks = (int)resolutionB;
        float radius = 0.6f;
        if (NewRenderProcedure.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
            int color = -1;
            for (int i = 0; i < stacks; ++i) {
                float theta1 = (float)(Math.PI * (double)i / (double)stacks);
                float theta2 = (float)(Math.PI * (double)(i + 1) / (double)stacks);
                for (int j = 0; j < slices; ++j) {
                    float phi1 = (float)(Math.PI * 2 * (double)j / (double)slices);
                    float phi22 = (float)(Math.PI * 2 * (double)(j + 1) / (double)slices);
                    float x12 = (float)((double)radius * Math.sin(theta1) * Math.cos(phi1));
                    float y1 = (float)((double)radius * Math.cos(theta1));
                    float z12 = (float)((double)radius * Math.sin(theta1) * Math.sin(phi1));
                    float x22 = (float)((double)radius * Math.sin(theta2) * Math.cos(phi1));
                    float y2 = (float)((double)radius * Math.cos(theta2));
                    float z22 = (float)((double)radius * Math.sin(theta2) * Math.sin(phi1));
                    float x32 = (float)((double)radius * Math.sin(theta2) * Math.cos(phi22));
                    float y3 = (float)((double)radius * Math.cos(theta2));
                    float z32 = (float)((double)radius * Math.sin(theta2) * Math.sin(phi22));
                    float x42 = (float)((double)radius * Math.sin(theta1) * Math.cos(phi22));
                    float y4 = (float)((double)radius * Math.cos(theta1));
                    float z42 = (float)((double)radius * Math.sin(theta1) * Math.sin(phi22));
                    float u12 = (float)((double)phi1 / (Math.PI * 2));
                    float v12 = (float)((double)theta1 / Math.PI);
                    float u22 = (float)((double)phi1 / (Math.PI * 2));
                    float v22 = (float)((double)theta2 / Math.PI);
                    float u32 = (float)((double)phi22 / (Math.PI * 2));
                    float v32 = (float)((double)theta2 / Math.PI);
                    float u42 = (float)((double)phi22 / (Math.PI * 2));
                    float v42 = (float)((double)theta1 / Math.PI);
                    NewRenderProcedure.add(x12, y1, z12, u12, v12, color);
                    NewRenderProcedure.add(x22, y2, z22, u22, v22, color);
                    NewRenderProcedure.add(x32, y3, z32, u32, v32, color);
                    NewRenderProcedure.add(x12, y1, z12, u12, v12, color);
                    NewRenderProcedure.add(x32, y3, z32, u32, v32, color);
                    NewRenderProcedure.add(x42, y4, z42, u42, v42, color);
                }
            }
            NewRenderProcedure.end();
        }
        RenderSystem.disableCull();
        if (NewRenderProcedure.target(2)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/p_concyderum.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), -258.0, 72.0, -155.0, 0.0f, 0.0f, 0.0f, 26.0f, 26.0f, 26.0f, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/p_frosthelm.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 104.0, -20.0, 60.0, 0.0f, 0.0f, 0.0f, 120.0f, 120.0f, 120.0f, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/p_anchoreanische.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 20000.0, 60.0, -4000.0, 0.0f, 0.0f, 0.0f, 120.0f, 120.0f, 120.0f, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/p_sendstina.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 23000.0, 100.0, 600.0, 0.0f, 0.0f, 0.0f, 120.0f, 120.0f, 120.0f, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/p_nyoldarria.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 21000.0, 80.0, 4000.0, 0.0f, 0.0f, 0.0f, 120.0f, 120.0f, 120.0f, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/p_dyschentya.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 600.0, 80.0, 21000.0, 0.0f, 0.0f, 0.0f, 120.0f, 120.0f, 120.0f, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/b_thick_snow.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), -1000.0, 300.0, -200.0, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, -1);
            RenderSystem.enableCull();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/b_thick_snow.png"));
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), -258.0, 72.0, -155.0, 0.0f, 0.0f, 0.0f, 29.0f, 29.0f, 29.0f, -595574529);
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 104.0, -20.0, 60.0, 0.0f, 0.0f, 0.0f, 124.0f, 124.0f, 124.0f, -1606401793);
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 20000.0, 60.0, -4000.0, 0.0f, 0.0f, 0.0f, 124.0f, 124.0f, 124.0f, -603979521);
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 23000.0, 100.0, 600.0, 0.0f, 0.0f, 0.0f, 124.0f, 124.0f, 124.0f, -1597454336);
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 21000.0, 80.0, 4000.0, 0.0f, 0.0f, 0.0f, 124.0f, 124.0f, 124.0f, -1602191105);
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 600.0, 80.0, 21000.0, 0.0f, 0.0f, 0.0f, 124.0f, 124.0f, 124.0f, -1593901056);
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), -1000.0, 300.0, -200.0, 0.0f, 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, -87499521);
            NewRenderProcedure.release();
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/p_ring.png"));
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float innerR = 1.4f;
        float outerR = 3.2f;
        if (NewRenderProcedure.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
            int color = -1;
            for (int i = 0; i < slices; ++i) {
                float phi1 = (float)(Math.PI * 2 * (double)i / (double)slices);
                phi2 = (float)(Math.PI * 2 * (double)(i + 1) / (double)slices);
                x1 = (float)((double)innerR * Math.cos(phi1));
                z1 = (float)((double)innerR * Math.sin(phi1));
                x2 = (float)((double)innerR * Math.cos(phi2));
                z2 = (float)((double)innerR * Math.sin(phi2));
                x3 = (float)((double)outerR * Math.cos(phi2));
                z3 = (float)((double)outerR * Math.sin(phi2));
                x4 = (float)((double)outerR * Math.cos(phi1));
                z4 = (float)((double)outerR * Math.sin(phi1));
                u1 = 0.5f + 0.5f * (x1 / outerR);
                v1 = 0.5f + 0.5f * (z1 / outerR);
                u2 = 0.5f + 0.5f * (x2 / outerR);
                v2 = 0.5f + 0.5f * (z2 / outerR);
                u3 = 0.5f + 0.5f * (x3 / outerR);
                v3 = 0.5f + 0.5f * (z3 / outerR);
                u4 = 0.5f + 0.5f * (x4 / outerR);
                v4 = 0.5f + 0.5f * (z4 / outerR);
                NewRenderProcedure.add(x1, 0.0f, z1, u1, v1, color);
                NewRenderProcedure.add(x2, 0.0f, z2, u2, v2, color);
                NewRenderProcedure.add(x3, 0.0f, z3, u3, v3, color);
                NewRenderProcedure.add(x1, 0.0f, z1, u1, v1, color);
                NewRenderProcedure.add(x3, 0.0f, z3, u3, v3, color);
                NewRenderProcedure.add(x4, 0.0f, z4, u4, v4, color);
            }
            NewRenderProcedure.end();
        }
        if (NewRenderProcedure.target(2)) {
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 104.0, -20.0, 60.0, -17.0f, 17.0f, 0.0f, 120.0f, 120.0f, 120.0f, -1601401716);
            NewRenderProcedure.release();
        }
        innerR = 4.0f;
        outerR = 4.4f;
        if (NewRenderProcedure.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
            int color = -1;
            for (int i = 0; i < slices; ++i) {
                float phi1 = (float)(Math.PI * 2 * (double)i / (double)slices);
                phi2 = (float)(Math.PI * 2 * (double)(i + 1) / (double)slices);
                x1 = (float)((double)innerR * Math.cos(phi1));
                z1 = (float)((double)innerR * Math.sin(phi1));
                x2 = (float)((double)innerR * Math.cos(phi2));
                z2 = (float)((double)innerR * Math.sin(phi2));
                x3 = (float)((double)outerR * Math.cos(phi2));
                z3 = (float)((double)outerR * Math.sin(phi2));
                x4 = (float)((double)outerR * Math.cos(phi1));
                z4 = (float)((double)outerR * Math.sin(phi1));
                u1 = 0.5f + 0.5f * (x1 / outerR);
                v1 = 0.5f + 0.5f * (z1 / outerR);
                u2 = 0.5f + 0.5f * (x2 / outerR);
                v2 = 0.5f + 0.5f * (z2 / outerR);
                u3 = 0.5f + 0.5f * (x3 / outerR);
                v3 = 0.5f + 0.5f * (z3 / outerR);
                u4 = 0.5f + 0.5f * (x4 / outerR);
                v4 = 0.5f + 0.5f * (z4 / outerR);
                NewRenderProcedure.add(x1, 0.0f, z1, u1, v1, color);
                NewRenderProcedure.add(x2, 0.0f, z2, u2, v2, color);
                NewRenderProcedure.add(x3, 0.0f, z3, u3, v3, color);
                NewRenderProcedure.add(x1, 0.0f, z1, u1, v1, color);
                NewRenderProcedure.add(x3, 0.0f, z3, u3, v3, color);
                NewRenderProcedure.add(x4, 0.0f, z4, u4, v4, color);
            }
            NewRenderProcedure.end();
        }
        if (NewRenderProcedure.target(2)) {
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), 104.0, -20.0, 60.0, -17.0f, 17.0f, 0.0f, 120.0f, 120.0f, 120.0f, 1348756580);
            NewRenderProcedure.release();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float uvShiftScale = 0.02f;
        if (NewRenderProcedure.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
            int color = -1;
            for (int i = 0; i < stacks; ++i) {
                float theta1 = (float)(Math.PI * (double)i / (double)stacks);
                float theta2 = (float)(Math.PI * (double)(i + 1) / (double)stacks);
                for (int j = 0; j < slices; ++j) {
                    int[][] tris;
                    float phi1 = (float)(Math.PI * 2 * (double)j / (double)slices);
                    float phi23 = (float)(Math.PI * 2 * (double)(j + 1) / (double)slices);
                    float[][] dirs = new float[][]{{(float)(Math.sin(theta1) * Math.cos(phi1)), (float)Math.cos(theta1), (float)(Math.sin(theta1) * Math.sin(phi1))}, {(float)(Math.sin(theta2) * Math.cos(phi1)), (float)Math.cos(theta2), (float)(Math.sin(theta2) * Math.sin(phi1))}, {(float)(Math.sin(theta2) * Math.cos(phi23)), (float)Math.cos(theta2), (float)(Math.sin(theta2) * Math.sin(phi23))}, {(float)(Math.sin(theta1) * Math.cos(phi23)), (float)Math.cos(theta1), (float)(Math.sin(theta1) * Math.sin(phi23))}};
                    float[][] uvs = new float[4][2];
                    for (int k = 0; k < 4; ++k) {
                        float dx = dirs[k][0];
                        float dy = dirs[k][1];
                        float dz = dirs[k][2];
                        float absDx = Math.abs(dx);
                        float absDy = Math.abs(dy);
                        float absDz = Math.abs(dz);
                        float u = 0.0f;
                        float v = 0.0f;
                        float faceX = 0.0f;
                        float faceY = 0.0f;
                        if (absDx >= absDy && absDx >= absDz) {
                            if (dx > 0.0f) {
                                u = -dz / absDx;
                                v = dy / absDx;
                                faceX = 0.0f;
                                faceY = 0.0f;
                            } else {
                                u = dz / absDx;
                                v = dy / absDx;
                                faceX = 1.0f;
                                faceY = 0.0f;
                            }
                        } else if (absDy >= absDx && absDy >= absDz) {
                            if (dy > 0.0f) {
                                u = dx / absDy;
                                v = -dz / absDy;
                                faceX = 2.0f;
                                faceY = 0.0f;
                            } else {
                                u = dx / absDy;
                                v = dz / absDy;
                                faceX = 0.0f;
                                faceY = 1.0f;
                            }
                        } else if (dz > 0.0f) {
                            u = dx / absDz;
                            v = dy / absDz;
                            faceX = 1.0f;
                            faceY = 1.0f;
                        } else {
                            u = -dx / absDz;
                            v = dy / absDz;
                            faceX = 2.0f;
                            faceY = 1.0f;
                        }
                        float uOffset = (float)x * uvShiftScale;
                        float vOffset = (float)z * uvShiftScale;
                        float U = (faceX + (u += uOffset)) / 3.0f;
                        float V = (faceY + (v += vOffset)) / 2.0f;
                        uvs[k][0] = U;
                        uvs[k][1] = V;
                    }
                    int[][] nArrayArray = tris = new int[][]{{0, 1, 2}, {0, 2, 3}};
                    int n = nArrayArray.length;
                    for (int k = 0; k < n; ++k) {
                        int[] tri;
                        for (int idx : tri = nArrayArray[k]) {
                            float[] d = dirs[idx];
                            float[] uv = uvs[idx];
                            NewRenderProcedure.add(d[0] * radius, d[1] * radius, d[2] * radius, uv[0], uv[1], color);
                        }
                    }
                }
            }
            NewRenderProcedure.end();
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/skybox_nebula_loop.png"));
        RenderSystem.enableCull();
        if (NewRenderProcedure.target(2)) {
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), -1000.0, 300.0, -200.0, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, -1);
            NewRenderProcedure.renderShape(NewRenderProcedure.shape(), -1000.0, 300.0, -200.0, 0.0f, 0.0f, 0.0f, 48.0f, 48.0f, 48.0f, -1);
            NewRenderProcedure.release();
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/skybox_blackhole.png"));
        RenderSystem.disableCull();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (NewRenderProcedure.target(2)) {
            for (int index0 = 0; index0 < 32; ++index0) {
                ray = loop1 + 10.0;
                NewRenderProcedure.renderShape(NewRenderProcedure.shape(), -1000.0, 300.0, -200.0, 0.0f, 0.0f, 0.0f, (float)ray, (float)ray, (float)ray, 0xFF000000 | (int)(80.0 - loop1 * 2.0) << 16 | 0xA00 | 0x78);
                loop1 += 4.0;
            }
            NewRenderProcedure.release();
        }
    }
}

