/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class RxSetupProcedure {
    private static RegisterDimensionSpecialEffectsEvent provider = null;

    public static void register(String name, DimensionSpecialEffects effects) {
        provider.register(ResourceLocation.fromNamespaceAndPath((String)"endertechinf", (String)name), effects);
    }

    public static void register(ResourceKey<Level> dimension, DimensionSpecialEffects effects) {
        provider.register(dimension.location(), effects);
    }

    public static DimensionSpecialEffects createOverworldEffects(boolean constantWhiteLight, boolean constantAmbientLight, final boolean fog) {
        return new EndertechinfModDimensionSpecialEffects(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, constantWhiteLight, constantAmbientLight){

            public Vec3 getBrightnessDependentFogColor(Vec3 color, float sunHeight) {
                return color.multiply((double)(sunHeight * 0.94f + 0.06f), (double)(sunHeight * 0.94f + 0.06f), (double)(sunHeight * 0.91f + 0.09f));
            }

            public boolean isFoggyAt(int x, int y) {
                return fog;
            }
        };
    }

    public static DimensionSpecialEffects createNetherEffects(boolean constantWhiteLight, boolean constantAmbientLight, final boolean fog) {
        return new EndertechinfModDimensionSpecialEffects(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, constantWhiteLight, constantAmbientLight){

            public Vec3 getBrightnessDependentFogColor(Vec3 color, float sunHeight) {
                return color;
            }

            public boolean isFoggyAt(int x, int y) {
                return fog;
            }
        };
    }

    public static DimensionSpecialEffects createEndEffects(boolean constantWhiteLight, boolean constantAmbientLight, final boolean fog) {
        return new EndertechinfModDimensionSpecialEffects(Float.NaN, false, DimensionSpecialEffects.SkyType.END, constantWhiteLight, constantAmbientLight){

            public Vec3 getBrightnessDependentFogColor(Vec3 color, float sunHeight) {
                return color.scale((double)0.15f);
            }

            public boolean isFoggyAt(int x, int y) {
                return fog;
            }
        };
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void setupDimensions(RegisterDimensionSpecialEffectsEvent event) {
        provider = event;
        RxSetupProcedure.execute((Event)event);
    }

    public static void execute() {
        RxSetupProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm")), RxSetupProcedure.createNetherEffects(false, true, false));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm_topside")), RxSetupProcedure.createOverworldEffects(false, false, false));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:eastern_nyoldarria")), RxSetupProcedure.createOverworldEffects(false, false, true));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:western_nyoldarria")), RxSetupProcedure.createOverworldEffects(false, false, true));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:sandworld")), RxSetupProcedure.createOverworldEffects(false, false, false));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:sandworld_server_room")), RxSetupProcedure.createOverworldEffects(false, false, false));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:deep_water_dimension")), RxSetupProcedure.createOverworldEffects(false, false, true));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:concyderum")), RxSetupProcedure.createOverworldEffects(false, false, true));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:plane_of_forgotten_souls")), RxSetupProcedure.createOverworldEffects(false, false, false));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:outer_space")), RxSetupProcedure.createEndEffects(true, false, false));
        RxSetupProcedure.register((ResourceKey<Level>)Level.END, RxSetupProcedure.createEndEffects(true, false, false));
        RxSetupProcedure.register((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:cathflkopfhnisvhe")), RxSetupProcedure.createOverworldEffects(false, false, false));
    }

    public static abstract class EndertechinfModDimensionSpecialEffects
    extends DimensionSpecialEffects {
        public static final Set<Predicate<Object[]>> CUSTOM_CLOUDS = new HashSet<Predicate<Object[]>>();
        public static final Set<Predicate<Object[]>> CUSTOM_SKY = new HashSet<Predicate<Object[]>>();
        public static final Set<Predicate<Object[]>> CUSTOM_WEATHER = new HashSet<Predicate<Object[]>>();
        public static final Set<Predicate<Object[]>> CUSTOM_EFFECTS = new HashSet<Predicate<Object[]>>();
        public static final Set<Consumer<Object[]>> CUSTOM_LIGHTS = new HashSet<Consumer<Object[]>>();

        public EndertechinfModDimensionSpecialEffects(float cloudHeight, boolean hasGround, DimensionSpecialEffects.SkyType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
            super(cloudHeight, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
        }

        public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
            if (CUSTOM_CLOUDS != null && !CUSTOM_CLOUDS.isEmpty()) {
                boolean flag = false;
                Object[] objects = new Object[]{level, ticks, Float.valueOf(partialTick), poseStack, camX, camY, camZ, modelViewMatrix, projectionMatrix};
                for (Predicate<Object[]> predicate : CUSTOM_CLOUDS) {
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableCull();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    flag |= predicate.test(objects);
                }
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.enableCull();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                return flag;
            }
            return true;
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            if (CUSTOM_SKY != null && !CUSTOM_SKY.isEmpty()) {
                boolean flag = false;
                Object[] objects = new Object[]{level, ticks, Float.valueOf(partialTick), modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog};
                for (Predicate<Object[]> predicate : CUSTOM_SKY) {
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableDepthTest();
                    RenderSystem.enableCull();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    flag |= predicate.test(objects);
                }
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.enableCull();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                return flag;
            }
            return true;
        }

        public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
            if (CUSTOM_WEATHER != null && !CUSTOM_WEATHER.isEmpty()) {
                boolean flag = false;
                Object[] objects = new Object[]{level, ticks, Float.valueOf(partialTick), lightTexture, camX, camY, camZ};
                lightTexture.turnOnLightLayer();
                for (Predicate<Object[]> predicate : CUSTOM_WEATHER) {
                    RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableCull();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    flag |= predicate.test(objects);
                }
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.enableCull();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
                lightTexture.turnOffLightLayer();
                return flag;
            }
            return true;
        }

        public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
            if (CUSTOM_EFFECTS != null && !CUSTOM_EFFECTS.isEmpty()) {
                boolean flag = false;
                Object[] objects = new Object[]{level, ticks, camera};
                for (Predicate<Object[]> predicate : CUSTOM_EFFECTS) {
                    flag |= predicate.test(objects);
                }
                return flag;
            }
            return true;
        }

        public void adjustLightmapColors(ClientLevel level, float partialTick, float skyDarken, float blockLightRedFlicker, float skyLight, int pixelX, int pixelY, Vector3f colors) {
            if (CUSTOM_LIGHTS != null && !CUSTOM_LIGHTS.isEmpty()) {
                Object[] objects = new Object[]{level, Float.valueOf(partialTick), Float.valueOf(skyDarken), Float.valueOf(blockLightRedFlicker), Float.valueOf(skyLight), pixelX, pixelY, colors};
                for (Consumer<Object[]> consumer : CUSTOM_LIGHTS) {
                    consumer.accept(objects);
                }
            }
        }
    }
}

