/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import eu.rxey.inf.init.EndertechinfModScreens;
import eu.rxey.inf.world.inventory.TipBoxGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class TipBoxGUIScreen
extends AbstractContainerScreen<TipBoxGUIMenu>
implements EndertechinfModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox input;

    public TipBoxGUIScreen(TipBoxGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("input")) {
                this.input.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.input.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.input.isFocused()) {
            return this.input.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String inputValue = this.input.getValue();
        super.resize(minecraft, width, height);
        this.input.setValue(inputValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
        this.input = new EditBox(this.font, this.leftPos + 28, this.topPos + 144, 118, 18, (Component)Component.translatable((String)"gui.endertechinf.tip_box_gui.input"));
        this.input.setMaxLength(8192);
        this.input.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TipBoxGUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "input", content, false);
            }
        });
        this.input.setHint((Component)Component.translatable((String)"gui.endertechinf.tip_box_gui.input"));
        this.addWidget((GuiEventListener)this.input);
    }
}

