/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import eu.rxey.inf.init.EndertechinfModBlocks;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderCoordinatorProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RenderCoordinatorProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RenderCoordinatorProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RenderCoordinatorProcedure.mode = mode;
                    RenderCoordinatorProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RenderCoordinatorProcedure.mode = mode;
                    RenderCoordinatorProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderCoordinatorProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderCoordinatorProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RenderCoordinatorProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RenderCoordinatorProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderCoordinatorProcedure.execute((Event)event, (LevelAccessor)level, pos.x(), pos.y(), pos.z(), (ResourceKey<Level>)level.dimension(), event.getRenderTick());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, ResourceKey<Level> dimension, double ticks) {
        RenderCoordinatorProcedure.execute(null, world, x, y, z, dimension, ticks);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, ResourceKey<Level> dimension, double ticks) {
        if (dimension == null) {
            return;
        }
        boolean found = false;
        double i = 0.0;
        double j = 0.0;
        double k = 0.0;
        double l = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        if (dimension != ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm_topside"))) {
            return;
        }
        RenderSystem.disableCull();
        if (RenderCoordinatorProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, false)) {
            float size = 0.4f;
            float height = 0.6f;
            int baseColor = -2130706433;
            int tipColor = 0x10FFFFFF;
            RenderCoordinatorProcedure.add(-size, 0.0f, -size, baseColor);
            RenderCoordinatorProcedure.add(size, 0.0f, -size, baseColor);
            RenderCoordinatorProcedure.add(size, 0.0f, size, baseColor);
            RenderCoordinatorProcedure.add(-size, 0.0f, size, baseColor);
            RenderCoordinatorProcedure.add(-size, 0.0f, -size, baseColor);
            RenderCoordinatorProcedure.add(size, 0.0f, -size, baseColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.add(size, 0.0f, -size, baseColor);
            RenderCoordinatorProcedure.add(size, 0.0f, size, baseColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.add(size, 0.0f, size, baseColor);
            RenderCoordinatorProcedure.add(-size, 0.0f, size, baseColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.add(-size, 0.0f, size, baseColor);
            RenderCoordinatorProcedure.add(-size, 0.0f, -size, baseColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.add(0.0f, height, 0.0f, tipColor);
            RenderCoordinatorProcedure.end();
        }
        sx = -1.0;
        for (int index0 = 0; index0 < 3; ++index0) {
            sy = -1.0;
            for (int index1 = 0; index1 < 2; ++index1) {
                sz = -1.0;
                for (int index2 = 0; index2 < 3; ++index2) {
                    if (world.getBlockState(BlockPos.containing((double)(x + sx), (double)(y + sy), (double)(z + sz))).getBlock() == EndertechinfModBlocks.NEUTRONIC_COORDINATOR.get() && RenderCoordinatorProcedure.target(2)) {
                        x1 = Math.ceil(x + sx) - 0.5;
                        y1 = Math.floor(y + sy) + 1.2;
                        z1 = Math.ceil(z + sz) - 0.5;
                        RenderCoordinatorProcedure.renderShape(RenderCoordinatorProcedure.shape(), x1, y1, z1, (float)ticks, 0.0f, 0.0f, 0.8f, 0.8f, 0.8f, -65536);
                        RenderCoordinatorProcedure.renderShape(RenderCoordinatorProcedure.shape(), RenderCoordinatorProcedure.getBlockNBTNumber(world, BlockPos.containing((double)(x + sx), (double)(y + sy), (double)(z + sz)), "Xinaccuracy") / 16.0 + x1, y1, RenderCoordinatorProcedure.getBlockNBTNumber(world, BlockPos.containing((double)(x + sx), (double)(y + sy), (double)(z + sz)), "Zinaccuracy") / 16.0 + z1, (float)ticks, (float)(RenderCoordinatorProcedure.getBlockNBTNumber(world, BlockPos.containing((double)(x + sx), (double)(y + sy), (double)(z + sz)), "Yinaccuracy") * 18.0), 0.0f, 0.8f, (float)(0.8 + RenderCoordinatorProcedure.getBlockNBTNumber(world, BlockPos.containing((double)(x + sx), (double)(y + sy), (double)(z + sz)), "Zinaccuracy") / 8.0), 0.8f, -16776961);
                        RenderCoordinatorProcedure.release();
                    }
                    sz += 1.0;
                }
                sy += 1.0;
            }
            sx += 1.0;
        }
    }

    private static double getBlockNBTNumber(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getDouble(tag);
        }
        return -1.0;
    }
}

