/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import eu.rxey.inf.network.EndertechinfModVariables;
import eu.rxey.inf.procedures.ReturnFTPLoreSignalProcedure;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class ReturnCubeProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        ReturnCubeProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                ReturnCubeProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    ReturnCubeProcedure.mode = mode;
                    ReturnCubeProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    ReturnCubeProcedure.mode = mode;
                    ReturnCubeProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        ReturnCubeProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            ReturnCubeProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            ReturnCubeProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            ReturnCubeProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReturnCubeProcedure.execute((Event)event, (LevelAccessor)level, (ResourceKey<Level>)level.dimension(), event.getRenderTick());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, ResourceKey<Level> dimension, double ticks) {
        ReturnCubeProcedure.execute(null, world, dimension, ticks);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, ResourceKey<Level> dimension, double ticks) {
        if (dimension == null) {
            return;
        }
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        String getPlanet = "";
        if (dimension != ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm_topside"))) {
            return;
        }
        if (EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_power) {
            return;
        }
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        getPlanet = "signal_default";
        x1 = 1017.5;
        y1 = 118.5;
        z1 = 1034.5;
        if (ReturnCubeProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, true)) {
            ReturnCubeProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
            ReturnCubeProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
            ReturnCubeProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
            ReturnCubeProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
            ReturnCubeProcedure.end();
        }
        if (ReturnCubeProcedure.target(2)) {
            if (EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_lock_x == 0.0 && EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_lock_z == 0.0) {
                getPlanet = "gui_planet_frosthelm";
            }
            if (EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_lock_x == 0.0 && EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_lock_z == 1.0) {
                getPlanet = "gui_planet_concyderum";
            }
            if (EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_lock_x == EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_randomX && EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_lock_z == EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_randomZ) {
                getPlanet = new DecimalFormat("signal_####").format(EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_randomN);
            }
            if (ReturnFTPLoreSignalProcedure.execute(world) == 0.0) {
                getPlanet = "signal_0";
            }
            if (ReturnFTPLoreSignalProcedure.execute(world) == 1.0) {
                getPlanet = "signal_1";
            }
            if (ReturnFTPLoreSignalProcedure.execute(world) == 2.0) {
                getPlanet = "signal_2";
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)("endertechinf:textures/" + getPlanet + ".png")));
            ReturnCubeProcedure.renderShape(ReturnCubeProcedure.shape(), x1, y1 + 0.5, z1, (float)(ticks / 8.0 + 0.0), -90.0f, 0.0f, (float)EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_zoomMultiplier, (float)EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_zoomMultiplier, (float)EndertechinfModVariables.MapVariables.get((LevelAccessor)world).ftp_zoomMultiplier, -1);
            ReturnCubeProcedure.release();
        }
        if (ReturnCubeProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
            ReturnCubeProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
            ReturnCubeProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
            ReturnCubeProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
            ReturnCubeProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
            ReturnCubeProcedure.end();
        }
        if (ReturnCubeProcedure.target(2)) {
            for (int index0 = 0; index0 < 15; ++index0) {
                ReturnCubeProcedure.renderShape(ReturnCubeProcedure.shape(), x1, 118.0 + (double)index0 * 0.1, z1, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, 100 - index0 * 5 << 24 | 0x640000 | 0x3200 | 0xC8);
                ReturnCubeProcedure.renderShape(ReturnCubeProcedure.shape(), 1022.5, 119.5, 1012.0 + (double)index0 * 0.2, 0.0f, 90.0f, 0.0f, 3.0f, 3.0f, 3.0f, 100 - index0 * 5 << 24 | 0x640000 | 0x3200 | 0xC8);
                ReturnCubeProcedure.renderShape(ReturnCubeProcedure.shape(), 1022.5, 110.5, 944.0 + (double)index0 * 0.2, 0.0f, 90.0f, 0.0f, 3.0f, 3.0f, 3.0f, 100 - index0 * 5 << 24 | 0x640000 | 0x3200 | 0xC8);
            }
            ReturnCubeProcedure.release();
        }
    }
}

