/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import eu.rxey.inf.init.EndertechinfModBlocks;
import eu.rxey.inf.init.EndertechinfModEntities;
import eu.rxey.inf.network.EndertechinfModVariables;
import eu.rxey.inf.procedures.HasSatelliteDishProcedure;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RxObjectsProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBackground(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, color, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RxObjectsProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        RxObjectsProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.getBlock();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            BlockEntity blockEntity = entityBlock.newBlockEntity(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.getBlockEntityRenderDispatcher().getRenderer(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
                blockEntity.setLevel((Level)level);
                blockEntityRenderer.render(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.getRenderShape() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            BlockRenderDispatcher dispatcher = minecraft.getBlockRenderer();
            ModelBlockRenderer renderer = dispatcher.getModelRenderer();
            BakedModel bakedModel = dispatcher.getBlockModel(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.last();
            int color = minecraft.getBlockColors().getColor(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.create((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.getBuffer(Sheets.translucentCullBlockSheet()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.NO_OVERLAY, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.level() != level) {
                entity = type.create((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.create((Level)level);
            data.put(type, entity);
        }
        RxObjectsProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick().getGameTimeDeltaPartialTick(false);
        int packedLight = glowing ? 0xF000F0 : Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(entity, partialTick);
        RxObjectsProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        EntityRenderer renderer = minecraft.getEntityRenderDispatcher().getRenderer(entity);
        Vec3 pos = provider.getCamera().getPosition();
        float offset = entity.getBbHeight() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y + (double)offset - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.translate(0.0f, -offset, 0.0f);
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.render(entity, entity.getViewYRot(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        ItemRenderer renderer = minecraft.getItemRenderer();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.renderStatic(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.level, packedLight, OverlayTexture.NO_OVERLAY, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).normalize().toVector3f();
        Matrix4f matrix4f = provider.getPoseStack().last().pose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        vertexConsumer.addVertex(matrix4f, (float)(x1 - pos.x()), (float)(y1 - pos.y()), (float)(z1 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
        vertexConsumer.addVertex(matrix4f, (float)(x2 - pos.x()), (float)(y2 - pos.y()), (float)(z2 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.getInstance().level;
            Entity entity = provider.getCamera().getEntity();
            Vec3 pos = entity.getPosition(provider.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RxObjectsProcedure.execute((Event)provider, (LevelAccessor)level, pos.x(), pos.y(), pos.z(), entity, provider.getRenderTick());
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, double ticks) {
        RxObjectsProcedure.execute(null, world, x, y, z, entity, ticks);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity, double ticks) {
        ResourceKey resourceKey;
        WorldGenLevel _wgl;
        ResourceKey resourceKey2;
        Level _lvl;
        if (entity == null) {
            return;
        }
        double planeX = 0.0;
        double planeZ = 0.0;
        double satelliteRotation = 0.0;
        if (world instanceof Level) {
            _lvl = (Level)world;
            resourceKey2 = _lvl.dimension();
        } else if (world instanceof WorldGenLevel) {
            _wgl = (WorldGenLevel)world;
            resourceKey2 = _wgl.getLevel().dimension();
        } else {
            resourceKey2 = Level.OVERWORLD;
        }
        if (resourceKey2 == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:eastern_nyoldarria"))) {
            if (EndertechinfModVariables.MapVariables.get((LevelAccessor)world).vfx_eastnyolPlane != 0.0) {
                planeX = x - 400.0 + EndertechinfModVariables.MapVariables.get((LevelAccessor)world).vfx_eastnyolPlane / 2.0;
                planeZ = z - 400.0 + EndertechinfModVariables.MapVariables.get((LevelAccessor)world).vfx_eastnyolPlane / 2.0;
                RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.NYOLDARRIAN_FIGHTER_A.get(), planeX, 380.0, planeZ, -45.0f, 0.0f, 0.0f, 0.4f, false);
                RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.NYOLDARRIAN_FIGHTER_A.get(), planeX + 16.0, 384.0, planeZ + 32.0, -45.0f, 0.0f, 0.0f, 0.4f, false);
            }
        } else if (HasSatelliteDishProcedure.execute(entity)) {
            satelliteRotation = EndertechinfModVariables.MapVariables.get((LevelAccessor)world).world_satelliteRotation + 210.0;
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.SATELLITE_DISH.get(), -300.0, 36.0, -300.0, (float)satelliteRotation, 0.0f, 0.0f, 40.0f, true);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.SATELLITE_DISH.get(), -200.0, 36.0, -200.0, (float)satelliteRotation, 0.0f, 0.0f, 40.0f, true);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.SATELLITE_DISH.get(), -100.0, 36.0, -100.0, (float)satelliteRotation, 0.0f, 0.0f, 40.0f, true);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.SATELLITE_BRIDGE.get(), -150.0, 175.0, -150.0, -45.0f, 0.0f, 0.0f, 16.0f, true);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.SATELLITE_BRIDGE.get(), -150.0, 175.0, -150.0, 135.0f, 0.0f, 0.0f, 16.0f, true);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.SATELLITE_BRIDGE.get(), -250.0, 175.0, -250.0, -45.0f, 0.0f, 0.0f, 16.0f, true);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.SATELLITE_BRIDGE.get(), -250.0, 175.0, -250.0, 135.0f, 0.0f, 0.0f, 16.0f, true);
        }
        if (world instanceof Level) {
            _lvl = (Level)world;
            resourceKey = _lvl.dimension();
        } else if (world instanceof WorldGenLevel) {
            _wgl = (WorldGenLevel)world;
            resourceKey = _wgl.getLevel().dimension();
        } else {
            resourceKey = Level.OVERWORLD;
        }
        if (resourceKey == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm_topside"))) {
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 1225.0, 107.0, 1094.0, 90.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 1175.0, 107.0, 1094.0, 90.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 1125.0, 107.0, 1094.0, 90.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 1069.0, 107.0, 1094.0, 125.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 1036.5, 108.0, 1070.5, 125.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 993.0, 110.0, 1040.0, 170.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 983.0, 107.0, 988.0, 180.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 983.0, 107.0, 938.0, 180.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 983.0, 107.0, 888.0, 180.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 983.0, 107.0, 838.0, 180.0f, 0.0f, 0.0f, 12.0f, false);
            RxObjectsProcedure.renderEntity((EntityType)EndertechinfModEntities.TOWER.get(), 983.0, 107.0, 788.0, 180.0f, 0.0f, 0.0f, 12.0f, false);
        }
        if (world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == EndertechinfModBlocks.ALYSIS_POD.get()) {
            RxObjectsProcedure.renderTexts("Metabolic Energy Level: " + new DecimalFormat("####").format(((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).ftp_hunger) + "%", entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.5, entity.getLookAngle().z + z, (float)ticks, 0.0f, 0.0f, 0.005f, -85530881, true);
            RxObjectsProcedure.renderTexts("Metabolic Energy Level: " + new DecimalFormat("####").format(((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).ftp_hunger) + "%", entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.5, entity.getLookAngle().z + z, (float)(ticks + 180.0), 0.0f, 0.0f, 0.005f, -85530881, true);
            RxObjectsProcedure.renderTexts("Somnolence Index: " + new DecimalFormat("####").format(((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).ftp_sleep) + "%", entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.6, entity.getLookAngle().z + z, (float)ticks, 0.0f, 0.0f, 0.005f, -85530881, true);
            RxObjectsProcedure.renderTexts("Somnolence Index: " + new DecimalFormat("####").format(((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).ftp_sleep) + "%", entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.6, entity.getLookAngle().z + z, (float)(ticks + 180.0), 0.0f, 0.0f, 0.005f, -85530881, true);
            RxObjectsProcedure.renderTexts("Neurochemical Balance: " + new DecimalFormat("####").format(((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).ftp_sanity) + "%", entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.7, entity.getLookAngle().z + z, (float)ticks, 0.0f, 0.0f, 0.005f, -85530881, true);
            RxObjectsProcedure.renderTexts("Neurochemical Balance: " + new DecimalFormat("####").format(((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).ftp_sanity) + "%", entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.7, entity.getLookAngle().z + z, (float)(ticks + 180.0), 0.0f, 0.0f, 0.005f, -85530881, true);
        }
        if (world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == EndertechinfModBlocks.TIP_BOX.get()) {
            RxObjectsProcedure.renderTexts(RxObjectsProcedure.getBlockNBTString(world, BlockPos.containing((double)x, (double)y, (double)z), "tip"), entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.7, entity.getLookAngle().z + z, (float)ticks, 0.0f, 0.0f, 0.005f, -85530881, true);
            RxObjectsProcedure.renderTexts(RxObjectsProcedure.getBlockNBTString(world, BlockPos.containing((double)x, (double)y, (double)z), "tip"), entity.getLookAngle().x + x, entity.getLookAngle().y + y + 1.7, entity.getLookAngle().z + z, (float)(ticks + 180.0), 0.0f, 0.0f, 0.005f, -85530881, true);
        }
    }

    private static String getBlockNBTString(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getString(tag);
        }
        return "";
    }
}

