/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.fluid;

import eu.rxey.inf.init.EndertechinfModBlocks;
import eu.rxey.inf.init.EndertechinfModFluidTypes;
import eu.rxey.inf.init.EndertechinfModFluids;
import eu.rxey.inf.init.EndertechinfModItems;
import eu.rxey.inf.init.EndertechinfModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class HoneyFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)EndertechinfModFluidTypes.HONEY_TYPE.get(), () -> (Fluid)EndertechinfModFluids.HONEY.get(), () -> (Fluid)EndertechinfModFluids.FLOWING_HONEY.get()).explosionResistance(100.0f).tickRate(36).levelDecreasePerBlock(2).slopeFindDistance(1).bucket(() -> (Item)EndertechinfModItems.HONEY_BUCKET.get()).block(() -> (LiquidBlock)EndertechinfModBlocks.HONEY.get());

    private HoneyFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)EndertechinfModParticleTypes.MELTED_GOLD.get();
    }

    public static class Flowing
    extends HoneyFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends HoneyFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

