/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import eu.rxey.inf.entity.FTPLavalampEntity;
import eu.rxey.inf.init.EndertechinfModBlocks;
import eu.rxey.inf.network.EndertechinfModVariables;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RxeyGlowProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RxeyGlowProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RxeyGlowProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RxeyGlowProcedure.mode = mode;
                    RxeyGlowProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RxeyGlowProcedure.mode = mode;
                    RxeyGlowProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RxeyGlowProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RxeyGlowProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RxeyGlowProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RxeyGlowProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RxeyGlowProcedure.execute((Event)event, (LevelAccessor)level, pos.x(), pos.y(), pos.z(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        RxeyGlowProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        boolean found = false;
        BlockState target = Blocks.AIR.defaultBlockState();
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        double scale = 0.0;
        double offset = 0.0;
        double distance = 0.0;
        double yaw1 = 0.0;
        double pitch1 = 0.0;
        double r1 = 0.0;
        double g1 = 0.0;
        double b1 = 0.0;
        if (!((EndertechinfModVariables.PlayerVariables)entity.getData(EndertechinfModVariables.PLAYER_VARIABLES)).player_volumetrics) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        if (RxeyGlowProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, false)) {
            RxeyGlowProcedure.add(0.5f, 0.0f, 0.5f, 0.0f, 0.0f, -1);
            RxeyGlowProcedure.add(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, -1);
            RxeyGlowProcedure.add(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, -1);
            RxeyGlowProcedure.add(-0.5f, 0.0f, 0.5f, 1.0f, 0.0f, -1);
            RxeyGlowProcedure.end();
        }
        yaw1 = entity.getYRot() + 180.0f;
        pitch1 = 90.0f - entity.getXRot();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/rxey_glow.png"));
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (RxeyGlowProcedure.target(2)) {
            sx = -12.0;
            for (int index0 = 0; index0 < 24; ++index0) {
                sy = -2.0;
                for (int index1 = 0; index1 < 10; ++index1) {
                    sz = -12.0;
                    for (int index2 = 0; index2 < 24; ++index2) {
                        target = world.getBlockState(BlockPos.containing((double)(x + sx), (double)(y + sy), (double)(z + sz)));
                        if (target.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"rxey:vfx/glow")))) {
                            int n;
                            Property property = target.getBlock().getStateDefinition().getProperty("blockstate");
                            if (property instanceof IntegerProperty) {
                                IntegerProperty _getip17 = (IntegerProperty)property;
                                n = (Integer)target.getValue((Property)_getip17);
                            } else {
                                n = -1;
                            }
                            if (n == 0) {
                                if (target.getBlock() == EndertechinfModBlocks.BONELAMP.get()) {
                                    r1 = 130.0;
                                    g1 = 180.0;
                                    b1 = 255.0;
                                } else if (target.getBlock() == EndertechinfModBlocks.MEMORY_CEILING_PANEL_LIGHT.get()) {
                                    r1 = 130.0;
                                    g1 = 180.0;
                                    b1 = 255.0;
                                } else if (target.getBlock() == EndertechinfModBlocks.WALL_LAMP.get()) {
                                    r1 = 255.0;
                                    g1 = 140.0;
                                    b1 = 0.0;
                                } else {
                                    r1 = 255.0;
                                    g1 = 255.0;
                                    b1 = 255.0;
                                }
                                x1 = Math.floor(x) + 0.5 + sx;
                                y1 = Math.floor(y) + 1.0 + sy;
                                z1 = Math.floor(z) + 0.5 + sz;
                                distance = Math.max(Math.abs(x1 - x), Math.abs(z1 - z));
                                x1 -= (x1 - x) * 0.2;
                                y1 -= (y1 - y) * 0.2;
                                z1 -= (z1 - z) * 0.2;
                                RxeyGlowProcedure.renderShape(RxeyGlowProcedure.shape(), x1, y1, z1, (float)yaw1, (float)pitch1, 0.0f, 2.0f, 2.0f, 2.0f, (int)(80.0 - distance * 6.0) << 24 | (int)r1 << 16 | (int)g1 << 8 | (int)b1);
                            }
                        }
                        sz += 1.0;
                    }
                    sy += 1.0;
                }
                sx += 1.0;
            }
            Vec3 _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(12.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                if (!(entityiterator instanceof FTPLavalampEntity)) continue;
                r1 = 255.0;
                g1 = 140.0;
                b1 = 0.0;
                x1 = entityiterator.getX();
                y1 = entityiterator.getY() + (double)entityiterator.getBbHeight();
                z1 = entityiterator.getZ();
                distance = Math.max(Math.abs(x1 - x), Math.abs(z1 - z));
                x1 -= (x1 - x) * 0.2;
                y1 -= (y1 - y) * 0.2;
                z1 -= (z1 - z) * 0.2;
                RxeyGlowProcedure.renderShape(RxeyGlowProcedure.shape(), x1, y1, z1, (float)yaw1, (float)pitch1, 0.0f, 2.0f, 2.0f, 2.0f, (int)(80.0 - distance * 6.0) << 24 | (int)r1 << 16 | (int)g1 << 8 | (int)b1);
            }
            RxeyGlowProcedure.release();
        }
    }
}

