/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.block;

import eu.rxey.inf.init.EndertechinfModBlocks;
import eu.rxey.inf.procedures.FireCopperUpdateTickProcedure;
import eu.rxey.inf.procedures.OnBlockCollisionProcedure;
import eu.rxey.inf.procedures.OnBlockTickProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FireCopperBlock
extends FlowerBlock {
    public FireCopperBlock() {
        super(MobEffects.DARKNESS, 100.0f, BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).randomTicks().sound(SoundType.SHROOMLIGHT).instabreak().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).lightLevel(s -> 10).noCollission().replaceable().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is((Block)EndertechinfModBlocks.COPPER_WOOL.get()) || groundState.is(Blocks.COPPER_ORE) || groundState.is(Blocks.DEEPSLATE_COPPER_ORE) || groundState.is(Blocks.RAW_COPPER_BLOCK) || groundState.is(Blocks.COPPER_BLOCK) || groundState.is(Blocks.EXPOSED_COPPER) || groundState.is(Blocks.WEATHERED_COPPER) || groundState.is(Blocks.OXIDIZED_COPPER) || groundState.is(Blocks.CUT_COPPER) || groundState.is(Blocks.EXPOSED_CUT_COPPER) || groundState.is(Blocks.WEATHERED_CUT_COPPER) || groundState.is(Blocks.OXIDIZED_CUT_COPPER) || groundState.is(Blocks.WAXED_COPPER_BLOCK) || groundState.is(Blocks.WAXED_EXPOSED_COPPER) || groundState.is(Blocks.WAXED_WEATHERED_COPPER) || groundState.is(Blocks.WAXED_OXIDIZED_COPPER) || groundState.is(Blocks.WAXED_CUT_COPPER) || groundState.is(Blocks.WAXED_EXPOSED_CUT_COPPER) || groundState.is(Blocks.WAXED_WEATHERED_CUT_COPPER) || groundState.is(Blocks.WAXED_OXIDIZED_CUT_COPPER);
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        FireCopperUpdateTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        OnBlockTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate, (Entity)Minecraft.getInstance().player);
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        OnBlockCollisionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), entity);
    }
}

