/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.client.particle;

import eu.rxey.inf.procedures.SnowpoofAdditionalParticleExpiryConditionProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnowpoofParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public static SnowpoofParticleProvider provider(SpriteSet spriteSet) {
        return new SnowpoofParticleProvider(spriteSet);
    }

    protected SnowpoofParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(1.0f, 1.0f);
        this.quadSize *= 0.8f;
        this.lifetime = Math.max(1, 30 + (this.random.nextInt(40) - 20));
        this.gravity = 0.1f;
        this.hasPhysics = true;
        this.xd = vx * 1.0;
        this.yd = vy * 1.0;
        this.zd = vz * 1.0;
        this.setSpriteFromAge(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        ClientLevel world;
        super.tick();
        if (!this.removed) {
            this.setSprite(this.spriteSet.get(this.age / 4 % 6 + 1, 6));
        }
        if (SnowpoofAdditionalParticleExpiryConditionProcedure.execute((LevelAccessor)(world = this.level), this.x, this.y, this.z)) {
            this.remove();
        }
    }

    public static class SnowpoofParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public SnowpoofParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SnowpoofParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

