/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import eu.rxey.inf.init.EndertechinfModParticleTypes;
import eu.rxey.inf.procedures.VFXExplosionProcedure;
import java.util.Comparator;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnergySphereOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        Entity target = null;
        if (!world.isClientSide()) {
            Level _level;
            entity.getPersistentData().putDouble("timeEnergy", entity.getPersistentData().getDouble("timeEnergy") + 1.0);
            if (entity.getPersistentData().getDouble("timeEnergy") % 10.0 == 0.0 && world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"endertechinf:sfx_sphere_hum")), SoundSource.HOSTILE, 1.0f, (float)(entity.getPersistentData().getDouble("timeEnergy") / 150.0));
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"endertechinf:sfx_sphere_hum")), SoundSource.HOSTILE, 1.0f, (float)(entity.getPersistentData().getDouble("timeEnergy") / 150.0), false);
                }
            }
            if (entity.getPersistentData().getDouble("timeEnergy") >= 200.0) {
                if (entity.getPersistentData().getBoolean("isParried") && world instanceof Level && !(_level = (Level)world).isClientSide()) {
                    _level.explode(null, x, y, z, 4.0f, Level.ExplosionInteraction.NONE);
                }
                if (!entity.level().isClientSide()) {
                    entity.discard();
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)EndertechinfModParticleTypes.PURPLE_TRAIL.get()), x, y, z, 32, 0.2, 0.2, 0.2, 1.0);
                }
                VFXExplosionProcedure.execute(world, x, y, z);
            }
            if (!entity.getPersistentData().getBoolean("isParried") && !world.getEntitiesOfClass(Player.class, new AABB(Vec3.ZERO, Vec3.ZERO).move(new Vec3(x, y, z)).inflate(30.0), e -> true).isEmpty()) {
                if (EnergySphereOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Player.class, x, y, z, 64.0) != null) {
                    target = EnergySphereOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Player.class, x, y, z, 64.0);
                    vx = target.getX() - x;
                    vy = target.getY() - y;
                    vz = target.getZ() - z;
                    entity.setDeltaMovement(new Vec3(vx * 0.08, vy * 0.08, vz * 0.08));
                    entity.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(EnergySphereOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Player.class, x, y, z, 60.0).getX(), EnergySphereOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Player.class, x, y, z, 60.0).getY() + 2.0, EnergySphereOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Player.class, x, y, z, 60.0).getZ()));
                    if (world instanceof ServerLevel) {
                        _level = (ServerLevel)world;
                        _level.sendParticles((ParticleOptions)((SimpleParticleType)EndertechinfModParticleTypes.PURPLE_TRAIL.get()), x, y + 0.8, z, 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
            } else if (entity.getPersistentData().getBoolean("isParried")) {
                entity.setDeltaMovement(new Vec3(entity.getPersistentData().getDouble("xValue"), entity.getPersistentData().getDouble("yValue"), entity.getPersistentData().getDouble("zValue")));
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)EndertechinfModParticleTypes.PURPLE_TRAIL.get()), x, y + 0.8, z, 1, 0.0, 0.0, 0.0, 0.02);
                }
            }
        }
    }

    private static Entity findEntityInWorldRange(LevelAccessor world, Class<? extends Entity> clazz, double x, double y, double z, double range) {
        return world.getEntitiesOfClass(clazz, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)range, (double)range, (double)range), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z))).findFirst().orElse(null);
    }
}

