/*
 * Decompiled with CFR 0.152.
 */
package eu.rxey.inf.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderMountainsProcedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RenderMountainsProcedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RenderMountainsProcedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RenderMountainsProcedure.mode = mode;
                    RenderMountainsProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RenderMountainsProcedure.mode = mode;
                    RenderMountainsProcedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderMountainsProcedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderMountainsProcedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RenderMountainsProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RenderMountainsProcedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderMountainsProcedure.execute((Event)event, entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(Entity entity) {
        RenderMountainsProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.level().dimension() != ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:frosthelm_topside"))) {
            return;
        }
        int gridSize = 6;
        float size = 2.0f;
        float half = size / 2.0f;
        float maxHeight = 0.3f;
        float texScale = 1024.0f;
        if (RenderMountainsProcedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR, false)) {
            for (int x = 0; x < gridSize; ++x) {
                for (int z = 0; z < gridSize; ++z) {
                    float nx0 = (float)x / (float)gridSize * 2.0f - 1.0f;
                    float nz0 = (float)z / (float)gridSize * 2.0f - 1.0f;
                    float nx1 = (float)(x + 1) / (float)gridSize * 2.0f - 1.0f;
                    float nz1 = (float)(z + 1) / (float)gridSize * 2.0f - 1.0f;
                    float x0 = nx0 * half;
                    float z0 = nz0 * half;
                    float x1 = nx1 * half;
                    float z1 = nz1 * half;
                    float dist0 = Math.max(Math.abs(nx0), Math.abs(nz0));
                    float dist1 = Math.max(Math.abs(nx1), Math.abs(nz0));
                    float dist2 = Math.max(Math.abs(nx1), Math.abs(nz1));
                    float dist3 = Math.max(Math.abs(nx0), Math.abs(nz1));
                    float n0 = Math.abs((float)Math.sin(x0 * 6.0f + z0 * 4.0f) * 0.6f + (float)Math.sin(x0 * 13.5f) * (float)Math.cos(z0 * 11.3f) * 0.4f);
                    float n1 = Math.abs((float)Math.sin(x1 * 6.0f + z0 * 4.0f) * 0.6f + (float)Math.sin(x1 * 13.5f) * (float)Math.cos(z0 * 11.3f) * 0.4f);
                    float n2 = Math.abs((float)Math.sin(x1 * 6.0f + z1 * 4.0f) * 0.6f + (float)Math.sin(x1 * 13.5f) * (float)Math.cos(z1 * 11.3f) * 0.4f);
                    float n3 = Math.abs((float)Math.sin(x0 * 6.0f + z1 * 4.0f) * 0.6f + (float)Math.sin(x0 * 13.5f) * (float)Math.cos(z1 * 11.3f) * 0.4f);
                    n0 = (float)Math.pow(n0, 2.2);
                    n1 = (float)Math.pow(n1, 2.2);
                    n2 = (float)Math.pow(n2, 2.2);
                    n3 = (float)Math.pow(n3, 2.2);
                    float h0 = dist0 < 0.5f ? 0.0f : dist0 * maxHeight * n0;
                    float h1 = dist1 < 0.5f ? 0.0f : dist1 * maxHeight * n1;
                    float h2 = dist2 < 0.5f ? 0.0f : dist2 * maxHeight * n2;
                    float h3 = dist3 < 0.5f ? 0.0f : dist3 * maxHeight * n3;
                    float u0 = x0 * texScale;
                    float v0 = z0 * texScale;
                    float u1 = x1 * texScale;
                    float v1 = z1 * texScale;
                    int color = -1;
                    RenderMountainsProcedure.add(x0, h0, z0, u0, v0, color);
                    RenderMountainsProcedure.add(x1, h1, z0, u1, v0, color);
                    RenderMountainsProcedure.add(x1, h2, z1, u1, v1, color);
                    RenderMountainsProcedure.add(x0, h3, z1, u0, v1, color);
                }
            }
            RenderMountainsProcedure.end();
        }
        RenderMountainsProcedure.system(true);
        if (RenderMountainsProcedure.target(2)) {
            RenderSystem.disableCull();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.parse((String)"endertechinf:textures/b_thick_snow.png"));
            RenderMountainsProcedure.renderShape(RenderMountainsProcedure.shape(), 976.0, 106.5, 1019.0, 0.0f, 0.0f, 0.0f, 1024.0f, 1024.0f, 1024.0f, -16250872);
            RenderMountainsProcedure.renderShape(RenderMountainsProcedure.shape(), 976.0, 105.5, 1019.0, 60.0f, 0.0f, 0.0f, 1224.0f, 1824.0f, 1224.0f, -435812858);
            RenderMountainsProcedure.release();
        }
    }
}

