/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.spitstik.listeners;

import java.util.Map;
import me.stokmenn.spitstik.GroupData;
import me.stokmenn.spitstik.SpitSTIK;
import me.stokmenn.spitstik.config.Config;
import me.stokmenn.spitstik.config.Messages;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public class SpitListener
implements Listener {
    private final Messages messages;

    public SpitListener(Messages messages) {
        this.messages = messages;
    }

    @EventHandler
    public void OnPlayerSpitPlayer(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player attacker = (Player)projectileSource;
        Entity entity = event.getHitEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        if (!(event.getEntity() instanceof LlamaSpit)) {
            return;
        }
        victim.sendMessage(this.messages.get("listener.spitReceive", Map.of("<player>", attacker.getName())));
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!Config.logCoreProtect) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof LlamaSpit)) {
            return;
        }
        LlamaSpit spit = (LlamaSpit)entity2;
        ProjectileSource projectileSource = spit.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        Material itemType = itemFrame.getItem().getType();
        if (itemType == Material.AIR) {
            return;
        }
        SpitSTIK.coreProtectAPI.logRemoval(Config.coreProtectPrefix + player.getName(), itemFrame.getLocation(), itemType, null);
    }

    @EventHandler
    public void OnSpit(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player attacker = (Player)projectileSource;
        if (!(event.getEntity() instanceof LlamaSpit)) {
            return;
        }
        boolean doDamage = Config.defaultDoDamage;
        for (GroupData group : Config.groups) {
            String permission = "SpitSTIK.group" + group.groupNumber();
            if (!attacker.hasPermission(permission)) continue;
            doDamage = group.doDamage();
            break;
        }
        if (!doDamage) {
            event.setCancelled(true);
        }
    }
}

