/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.spitstik.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.stokmenn.spitstik.GroupData;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private static JavaPlugin plugin;
    public static int defaultCooldown;
    public static double defaultVelocity;
    public static boolean defaultUseSound;
    public static boolean defaultDoDamage;
    public static float defaultVolume;
    public static float defaultPitch;
    public static Set<Material> defaultMaterials;
    public static boolean logCoreProtect;
    public static String coreProtectPrefix;
    public static boolean useSpecialGroups;
    public static final List<GroupData> groups;

    public static void init(JavaPlugin plugin) {
        Config.plugin = plugin;
        plugin.saveDefaultConfig();
        Config.reload();
    }

    public static void reload() {
        plugin.reloadConfig();
        FileConfiguration config = plugin.getConfig();
        defaultCooldown = config.getInt("defaultCooldown", 10000);
        defaultVelocity = config.getDouble("defaultVelocity", 0.4);
        defaultUseSound = config.getBoolean("defaultUseSound", true);
        defaultDoDamage = config.getBoolean("defaultDoDamage", false);
        defaultVolume = (float)config.getDouble("defaultVolume", 1.0);
        defaultPitch = (float)config.getDouble("defaultPitch", 1.0);
        defaultMaterials.clear();
        for (String materialName : config.getStringList("defaultMaterialsList")) {
            Material material = Material.getMaterial((String)materialName);
            if (material == null) {
                plugin.getLogger().warning("Invalid material name: " + materialName);
                continue;
            }
            defaultMaterials.add(material);
        }
        logCoreProtect = config.getBoolean("logCoreProtect", false);
        coreProtectPrefix = config.getString("coreProtectPrefix", "#SpitSTIK-");
        useSpecialGroups = config.getBoolean("useSpecialGroups", false);
        if (!useSpecialGroups) {
            return;
        }
        groups.clear();
        ConfigurationSection groupsSection = config.getConfigurationSection("groups");
        if (groupsSection == null) {
            plugin.getLogger().warning("'groups' section not found");
            return;
        }
        for (String groupKey : groupsSection.getKeys(false)) {
            int groupNumber;
            ConfigurationSection groupSection;
            if (!groupKey.matches("group\\d+") || (groupSection = groupsSection.getConfigurationSection(groupKey)) == null) continue;
            try {
                groupNumber = Integer.parseInt(groupKey.replace("group", ""));
            }
            catch (NumberFormatException e) {
                plugin.getLogger().warning("Invalid group name: " + groupKey);
                continue;
            }
            int cooldown = groupSection.getInt("cooldown", defaultCooldown);
            double velocity = groupSection.getDouble("velocity", defaultVelocity);
            boolean useSound = groupSection.getBoolean("useSound", defaultUseSound);
            boolean doDamage = groupSection.getBoolean("doDamage", defaultDoDamage);
            float volume = (float)groupSection.getDouble("volume", (double)defaultVolume);
            float pitch = (float)groupSection.getDouble("pitch", (double)defaultPitch);
            HashSet<Material> materials = new HashSet<Material>();
            for (String materialName : groupSection.getStringList("materialsList")) {
                Material material = Material.getMaterial((String)materialName);
                if (material == null) {
                    plugin.getLogger().warning("Invalid material name: " + materialName);
                    continue;
                }
                materials.add(material);
            }
            groups.add(new GroupData(groupNumber, cooldown, velocity, useSound, doDamage, volume, pitch, materials));
        }
        groups.sort(Comparator.comparingInt(GroupData::groupNumber).reversed());
    }

    static {
        defaultMaterials = new HashSet<Material>();
        groups = new ArrayList<GroupData>();
    }
}

