/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.spitstik.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Messages {
    private final File configFile;
    private YamlConfiguration config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Map<String, Component> messages = new HashMap<String, Component>();

    public Messages(JavaPlugin plugin) {
        this.configFile = new File(plugin.getDataFolder(), "messages.yml");
        plugin.saveResource("messages.yml", false);
        this.reload();
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messages.clear();
        this.initMessage("configReloaded", "<green>\u2714 Config has been reloaded");
        this.initMessage("listener.spitReceive", "Player <player> spat on you");
        this.initMessage("command.onlyPlayerCanUse", "<red>\u2718 This command can only be used by a player");
        this.initMessage("command.noPermissionToUse", "<red>\u2718 You do not have permission to use this command");
        this.initMessage("command.wrongMaterial", "<red>\u2718 <white>You need special item in hand to use this command");
        this.initMessage("command.noPermissionToReload", "<red>\u2718 You do not have permission to reload the SpitSTIK plugin");
        this.initMessage("command.cooldownRemaining", "<red>\u2718 Please wait <cooldownRemaining>s.");
    }

    private void initMessage(String path, String def) {
        this.messages.put(path, this.miniMessage.deserialize((Object)this.config.getString(path, def)));
    }

    public Component get(String key) {
        return this.messages.get(key);
    }

    public Component get(String key, Map<String, Object> placeholders) {
        Component message = this.messages.get(key);
        for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
            message = message.replaceText(builder -> builder.match((String)entry.getKey()).replacement((ComponentLike)Component.text((String)entry.getValue().toString())));
        }
        return message;
    }
}

