/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.mcreator.crustychunks.network.CrustyChunksModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="warium_additions", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CustomCrosshairOverlay {
    private static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/icons.png");
    private static final ResourceLocation ICONS_SNEAK = ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/iconssneak.png");
    private static final ResourceLocation ICONS_SHOTGUN = ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/iconshotgun.png");
    private static final ResourceLocation ICONS_SHOTGUN_SNEAK = ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/iconshotgunsneak.png");
    private static final ResourceLocation PUMP_SHOTGUN = ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"pump_action_shotgun_animated");
    private static final ResourceLocation BREAK_SHOTGUN = ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"break_action_shotgun_animated");

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderCrosshairPre(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().toString().equals("minecraft:crosshair")) {
            ItemStack mainHandItem;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null && mc.f_91066_.m_92176_().m_90612_() && (mainHandItem = player.m_21205_()).m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.m_135820_((String)"crusty_chunks:firearm")))) {
                event.setCanceled(true);
                ResourceLocation crosshairTexture = CustomCrosshairOverlay.getCrosshairTexture((Player)player, mainHandItem);
                if (crosshairTexture != null) {
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)crosshairTexture);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    int crosshairSize = 16;
                    event.getGuiGraphics().m_280163_(crosshairTexture, (mc.m_91268_().m_85445_() - crosshairSize) / 2, (mc.m_91268_().m_85446_() - crosshairSize) / 2, 0.0f, 0.0f, crosshairSize, crosshairSize, 256, 256);
                    RenderSystem.disableBlend();
                }
            }
        }
    }

    private static ResourceLocation getCrosshairTexture(Player player, ItemStack mainHandItem) {
        boolean isAiming = ((CrustyChunksModVariables.PlayerVariables)player.getCapability((Capability)CrustyChunksModVariables.PLAYER_VARIABLES_CAPABILITY).orElse((Object)new CrustyChunksModVariables.PlayerVariables())).AimDownSights;
        return List.of(PUMP_SHOTGUN, BREAK_SHOTGUN).contains(ForgeRegistries.ITEMS.getKey((Object)mainHandItem.m_41720_())) ? (isAiming ? ICONS_SHOTGUN_SNEAK : ICONS_SHOTGUN) : (isAiming ? ICONS_SNEAK : ICONS);
    }
}

