/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.compat.curios;

import com.google.common.collect.ImmutableMultimap;
import java.util.UUID;
import net.mcreator.crustychunks.init.CrustyChunksModItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosEvents {
    private static final ImmutableMultimap<String, AttributeModifier> HARDPOINT_SLOT_MAP = ImmutableMultimap.of((Object)"hardpoint", (Object)new AttributeModifier(UUID.fromString("14881488-1488-1488-1488-148814881488"), "Hardpoint", 1.0, AttributeModifier.Operation.ADDITION));
    private static final ImmutableMultimap<String, AttributeModifier> AMMOBOX_SLOT_MAP = ImmutableMultimap.of((Object)"ammobox", (Object)new AttributeModifier(UUID.fromString("69696969-6969-6969-6969-696969696969"), "Ammobox", 1.0, AttributeModifier.Operation.ADDITION));

    @SubscribeEvent
    public static void onCurioChange(CurioChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> {
                int i;
                int slots;
                IDynamicStackHandler stacks;
                ICurioStacksHandler requiredSlot = inventory.getStacksHandler("back").orElse(null);
                ICurioStacksHandler targetSlot = inventory.getStacksHandler("hardpoint").orElse(null);
                boolean hasItem = false;
                if (requiredSlot != null && targetSlot != null) {
                    stacks = requiredSlot.getStacks();
                    slots = targetSlot.getSlots();
                    for (i = 0; i < stacks.getSlots(); ++i) {
                        if (!stacks.getStackInSlot(i).m_150930_((Item)CrustyChunksModItems.EMPTY_MISSILE_HARDPOINT.get())) continue;
                        hasItem = true;
                        break;
                    }
                    if (hasItem && slots == 0) {
                        inventory.addTransientSlotModifiers(HARDPOINT_SLOT_MAP);
                    } else if (!hasItem && slots > 0) {
                        inventory.removeSlotModifiers(HARDPOINT_SLOT_MAP);
                    }
                }
                requiredSlot = inventory.getStacksHandler("head").orElse(null);
                targetSlot = inventory.getStacksHandler("ammobox").orElse(null);
                if (requiredSlot != null && targetSlot != null) {
                    stacks = requiredSlot.getStacks();
                    hasItem = false;
                    slots = targetSlot.getSlots();
                    for (i = 0; i < stacks.getSlots(); ++i) {
                        if (!stacks.getStackInSlot(i).m_150930_((Item)CrustyChunksModItems.LIGHT_MACHINE_GUN.get())) continue;
                        hasItem = true;
                        break;
                    }
                    if (hasItem && slots == 0) {
                        inventory.addTransientSlotModifiers(AMMOBOX_SLOT_MAP);
                    } else if (!hasItem && slots > 0) {
                        inventory.removeSlotModifiers(AMMOBOX_SLOT_MAP);
                    }
                }
            });
        }
    }
}

