/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.compat.jei;

import com.mojang.blaze3d.platform.InputConstants;
import crazywoddman.warium_additions.compat.jei.LatheRecipes;
import crazywoddman.warium_additions.compat.jei.WariumJEI;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;

public class LatheCategory
implements IRecipeCategory<LatheRecipes> {
    public static final RecipeType<LatheRecipes> TYPE = RecipeType.create((String)"crusty_chunks", (String)"lathe", LatheRecipes.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;

    private int ticks() {
        return (int)(System.currentTimeMillis() / 50L);
    }

    private boolean isDropoff() {
        return this.ticks() / 20 % 2 == 0;
    }

    public LatheCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(92, 40);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("lathe"));
        this.slot = guiHelper.getSlotDrawable();
    }

    public RecipeType<LatheRecipes> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Lathe");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LatheRecipes recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addInputSlot(1, 20).addItemStack(recipe.getInput())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addOutputSlot(75, 20).addItemStack(recipe.getOutput())).setBackground(this.slot, -1, -1);
    }

    public void draw(LatheRecipes recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(27.0f, 0.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.25f, 0.25f, 1.0f);
        graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"warium_additions", (String)(this.isDropoff() ? "textures/jei/lathe_conveyor.png" : "textures/jei/lathe_dropoff.png")), 0, 0, 0.0f, 0.0f, 152, 160, 152, 160);
        graphics.m_280168_().m_85849_();
        if (mouseX >= 27.0 && mouseX <= 49.0 && mouseY >= 0.0 && mouseY <= 40.0) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.addAll(WariumAdditionsUtil.getWariumStack("lathe").m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)));
            tooltip.add(1, Component.m_237113_((String)"Requires rotation force").m_130940_(ChatFormatting.GOLD));
            graphics.m_280245_(Minecraft.m_91087_().f_91062_, tooltip.stream().map(Component::m_7532_).toList(), (int)mouseX, (int)mouseY);
        }
        if (mouseX >= 50.0 && mouseX <= 64.0 && mouseY >= 16.0 && mouseY <= 34.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, this.isDropoff() ? WariumAdditionsUtil.getWariumStack("conveyor") : WariumAdditionsUtil.getWariumStack("conveyor_dropoff"), (int)mouseX, (int)mouseY);
        }
    }

    public boolean handleInput(LatheRecipes recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && input.m_84873_() == 0 && WariumJEI.jeiRuntime != null) {
            if (mouseX >= 27.0 && mouseX <= 49.0 && mouseY >= 0.0 && mouseY <= 40.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("lathe"))));
                return true;
            }
            if (mouseX >= 50.0 && mouseX <= 64.0 && mouseY >= 16.0 && mouseY <= 34.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)(this.isDropoff() ? WariumAdditionsUtil.getWariumStack("conveyor") : WariumAdditionsUtil.getWariumStack("conveyor_dropoff")))));
                return true;
            }
        }
        return false;
    }
}

