/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.crusty_chunks.energy;

import crazywoddman.warium_additions.config.Config;
import net.mcreator.crustychunks.block.entity.SolarGeneratorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SolarGeneratorBlockEntity.class})
public class SolarGeneratorBlockEntityMixin {
    @Unique
    private EnergyStorage energyStorage;
    private final int generation;

    public SolarGeneratorBlockEntityMixin() {
        this.generation = (Integer)Config.SERVER.solarGeneration.get();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void injectEnergyStorage(BlockPos position, BlockState state, CallbackInfo ci) {
        this.energyStorage = new EnergyStorage(this.generation, 0, this.generation){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (simulate) {
                    return 0;
                }
                this.energy = maxReceive;
                return maxReceive;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }
        };
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void injectRead(CompoundTag compound, CallbackInfo ci) {
        this.energyStorage.deserializeNBT(compound.m_128423_("energyStorage"));
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void injectSave(CompoundTag compound, CallbackInfo ci) {
        compound.m_128365_("energyStorage", this.energyStorage.serializeNBT());
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectEnergyCapability(Capability<?> capability, Direction facing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.ENERGY && (facing == null || facing == Direction.DOWN)) {
            cir.setReturnValue((Object)LazyOptional.of(() -> this.energyStorage).cast());
        }
    }
}

