/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.supplementaries;

import com.google.common.collect.HashBiMap;
import crazywoddman.warium_additions.recipe.ColoringRecipe;
import crazywoddman.warium_additions.recipe.ColoringRecipeRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.mehvahdjukaar.supplementaries.common.utils.BlockPredicate;
import net.mehvahdjukaar.supplementaries.common.utils.SoapWashableHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Restriction(require={@Condition(value="supplementaries")})
@Mixin(value={SoapWashableHelper.class}, remap=false)
public class SoapWashableHelperMixin {
    @Redirect(method={"tryChangingColor"}, at=@At(value="INVOKE", target="Ljava/util/function/Supplier;get()Ljava/lang/Object;", ordinal=0), require=0)
    private static Object redirectSoapBlacklistGet(Supplier<List<String>> instance) {
        List<String> original = instance.get();
        List<String> extended = ColoringRecipeRegistry.getPatternsForSoapBlacklist();
        if (extended.size() > 0) {
            original.addAll(extended);
        }
        return original;
    }

    @Redirect(method={"tryUnoxidise", "tryCleanFromConfig"}, at=@At(value="INVOKE", target="Ljava/util/function/Supplier;get()Ljava/lang/Object;", ordinal=0))
    private static Object redirectSoapSpecialGet(Supplier<Map<BlockPredicate, ResourceLocation>> instance) {
        HashBiMap extended = HashBiMap.create();
        for (ColoringRecipe template : ColoringRecipeRegistry.getCachedRecipes()) {
            String base = template.baseIngredient;
            if (!base.startsWith("#")) continue;
            TagKey tag = ItemTags.create((ResourceLocation)ResourceLocation.m_135820_((String)base.substring(1)));
            ITag items = ForgeRegistries.ITEMS.tags().getTag(tag);
            if (items.isEmpty()) continue;
            String firstItemId = ForgeRegistries.ITEMS.getKey((Object)((Item)items.iterator().next())).toString();
            extended.put((Object)BlockPredicate.create((String)base), (Object)ResourceLocation.m_135820_((String)firstItemId));
        }
        return extended;
    }
}

