/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.mcreator.crustychunks.entity.BulletfireProjectileEntity;
import net.mcreator.crustychunks.entity.FireSpearRocketProjectileEntity;
import net.mcreator.crustychunks.entity.RadarSpearMissileProjectileEntity;
import net.mcreator.crustychunks.entity.SeekerSpearMissileProjectileEntity;
import net.mcreator.crustychunks.entity.StrikeSpearProjectileEntity;
import net.mcreator.crustychunks.init.CrustyChunksModEntities;
import net.mcreator.crustychunks.init.CrustyChunksModItems;
import net.mcreator.crustychunks.procedures.CasingDropProcedure;
import net.mcreator.crustychunks.procedures.MediumFireSoundProcedure;
import net.mcreator.crustychunks.procedures.MuzzleFlashProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class ShootKeyPacket {
    public void encode(FriendlyByteBuf buffer) {
    }

    public static ShootKeyPacket decode(FriendlyByteBuf buffer) {
        return new ShootKeyPacket();
    }

    private static Optional<IDynamicStackHandler> getSlot(ICuriosItemHandler inventory, String slot) {
        ICurioStacksHandler handler = inventory.getStacksHandler(slot).orElse(null);
        IDynamicStackHandler stacks = handler.getStacks();
        if (handler != null && stacks.getSlots() > 0 && !stacks.getStackInSlot(0).m_41619_()) {
            return Optional.of(stacks);
        }
        return Optional.empty();
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            Level level = player.m_9236_();
            if (player != null) {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> {
                    ShootKeyPacket.getSlot(inventory, "hardpoint").ifPresent(handler -> {
                        FireSpearRocketProjectileEntity missile;
                        Vec3 pos = player.m_146892_();
                        switch (ForgeRegistries.ITEMS.getKey((Object)handler.getStackInSlot(0).m_41720_()).m_135815_()) {
                            case "fire_spear_rocket": {
                                FireSpearRocketProjectileEntity fireSpearRocketProjectileEntity = new FireSpearRocketProjectileEntity((EntityType)CrustyChunksModEntities.FIRE_SPEAR_ROCKET_PROJECTILE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, level);
                                break;
                            }
                            case "seeker_spear_rocket": {
                                FireSpearRocketProjectileEntity fireSpearRocketProjectileEntity = new SeekerSpearMissileProjectileEntity((EntityType)CrustyChunksModEntities.SEEKER_SPEAR_MISSILE_PROJECTILE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, level);
                                break;
                            }
                            case "radar_spear_missile": {
                                FireSpearRocketProjectileEntity fireSpearRocketProjectileEntity = new RadarSpearMissileProjectileEntity((EntityType)CrustyChunksModEntities.RADAR_SPEAR_MISSILE_PROJECTILE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, level);
                                break;
                            }
                            default: {
                                FireSpearRocketProjectileEntity fireSpearRocketProjectileEntity = missile = new StrikeSpearProjectileEntity((EntityType)CrustyChunksModEntities.STRIKE_SPEAR_PROJECTILE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, level);
                            }
                        }
                        double tilt = player.m_20143_() ? 0.9 : (player.m_6047_() ? 0.4 : 0.2);
                        Vec3 look = player.m_20154_();
                        Vec3 horizontalLook = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
                        Vec3 direction = new Vec3(0.0, 1.0, 0.0).m_82490_(1.0 - tilt).m_82549_(horizontalLook.m_82490_(tilt)).m_82541_();
                        missile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 4.0f, 2.0f);
                        if (level.m_7967_((Entity)missile) && !player.m_7500_()) {
                            handler.setStackInSlot(0, ItemStack.f_41583_);
                        }
                    });
                    ShootKeyPacket.getSlot(inventory, "ammobox").ifPresent(handler -> {
                        int ammo;
                        CompoundTag nbt;
                        CompoundTag playerData = player.getPersistentData();
                        long tick = level.m_46467_();
                        if (Math.abs(playerData.m_128454_("WAlastShot") - tick) > 1L && (nbt = handler.getStackInSlot(0).m_41784_()).m_128451_("AmmoSize") == -1 && (ammo = nbt.m_128451_("Ammo")) > 0) {
                            Vec3 pos = player.m_146892_();
                            Vec3 look = player.m_20154_();
                            Vec3 frontpos = pos.m_82549_(look.m_82490_(1.5));
                            BulletfireProjectileEntity bullet = new BulletfireProjectileEntity((EntityType)CrustyChunksModEntities.BULLETFIRE_PROJECTILE.get(), frontpos.f_82479_, frontpos.f_82480_, frontpos.f_82481_, level);
                            bullet.m_6686_(look.f_82479_, look.f_82480_, look.f_82481_, 7.5f, 0.9f);
                            bullet.m_20225_(true);
                            if (level.m_7967_((Entity)bullet)) {
                                ItemStack item = new ItemStack((ItemLike)CrustyChunksModItems.MEDIUM_CASING.get());
                                playerData.m_128356_("WAlastShot", tick);
                                MuzzleFlashProcedure.execute((LevelAccessor)level, (double)frontpos.f_82479_, (double)frontpos.f_82480_, (double)frontpos.f_82481_);
                                CasingDropProcedure.execute((LevelAccessor)level, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
                                MediumFireSoundProcedure.execute((LevelAccessor)level, (double)frontpos.f_82479_, (double)frontpos.f_82480_, (double)frontpos.f_82481_);
                                if (!player.m_7500_()) {
                                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20, 0, false, false));
                                    nbt.m_128405_("Ammo", ammo - 1);
                                    if (!player.m_36356_(item)) {
                                        level.m_7967_((Entity)new ItemEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, item));
                                    }
                                }
                            }
                        }
                    });
                });
            }
        });
        context.get().setPacketHandled(true);
    }
}

