/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions;

import crazywoddman.warium_additions.WariumPonder;
import crazywoddman.warium_additions.config.ClothConfig;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.recipe.WariumAdditionsRecipeTypes;
import crazywoddman.warium_additions.registrate.CreateBlockEntities;
import crazywoddman.warium_additions.registrate.CreateBlocks;
import crazywoddman.warium_additions.registrate.CreateFluids;
import crazywoddman.warium_additions.registrate.CreateItems;
import crazywoddman.warium_additions.registrate.Registrate;
import crazywoddman.warium_additions.registry.RegistryBlockEntities;
import crazywoddman.warium_additions.registry.RegistryBlocks;
import crazywoddman.warium_additions.registry.RegistryItems;
import net.mcreator.crustychunks.procedures.Rad1TickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="warium_additions")
public class WariumAdditions {
    public static final String MODID = "warium_additions";
    private static final ModList modlist = ModList.get();
    public static final boolean supplementariesLoaded = modlist.isLoaded("supplementaries");
    public static final boolean valkyrienWariumLoaded = modlist.isLoaded("valkyrien_warium");
    public static final boolean IEloaded = modlist.isLoaded("immersiveengineering");
    public static final boolean createLoaded = modlist.getModContainerById("create").map(container -> container.getModInfo().getVersion().toString().equals("0.5.1.j")).orElse(false);

    public WariumAdditions(FMLJavaModLoadingContext context) {
        IEventBus bus = context.getModEventBus();
        RegistryBlocks.WARIUM_REGISTRY.register(bus);
        RegistryItems.WARIUM_REGISTRY.register(bus);
        if (createLoaded || supplementariesLoaded) {
            WariumAdditionsRecipeTypes.register();
            WariumAdditionsRecipeTypes.Recipes.SERIALIZER_REGISTER.register(bus);
            WariumAdditionsRecipeTypes.Recipes.TYPE_REGISTER.register(bus);
        }
        if (modlist.isLoaded("valkyrien_warium")) {
            RegistryItems.REGISTRY.register(bus);
            RegistryBlocks.REGISTRY.register(bus);
            RegistryBlocks.OLD_REGISTRY.register(bus);
            RegistryBlockEntities.REGISTRY.register(bus);
            RegistryBlockEntities.OLD_REGISTRY.register(bus);
        }
        if (createLoaded) {
            context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
            Registrate.register(bus);
            CreateBlocks.register();
            CreateBlockEntities.register();
            CreateItems.register();
            CreateFluids.register();
        }
    }

    @Mod.EventBusSubscriber(modid="warium_additions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public class Events {
        @SubscribeEvent
        public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
            if (createLoaded && event.getItemStack().m_150930_((Item)CreateItems.YELLOWCAKE.get())) {
                event.setBurnTime(12800);
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            BlockPos pos;
            Player player;
            Level level;
            if (createLoaded && (level = (player = event.player).m_9236_()).m_6425_(pos = player.m_20183_()).m_76152_() == ((ForgeFlowingFluid.Flowing)CreateFluids.YELLOWCAKE_FLUID.get()).m_5613_() && player.f_19797_ % 10 == 0) {
                Rad1TickProcedure.execute((LevelAccessor)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="warium_additions", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (modlist.isLoaded("cloth_config")) {
                ClothConfig.registerConfigScreen();
            }
            if (modlist.isLoaded("ponderjs")) {
                WariumPonder.kubeJSreloadScripts(event);
            }
        }

        @SubscribeEvent
        public static void onBuildCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (createLoaded) {
                if (event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"warium_logistics"))) {
                    event.m_246342_(CreateBlocks.KINETIC_CONVERTER.asStack());
                    event.m_246342_(CreateBlocks.ROTATION_CONVERTER.asStack());
                }
                if (event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"crusty_production"))) {
                    event.m_246326_((ItemLike)CreateItems.YELLOWCAKE.get());
                }
                if (event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"crusty_components"))) {
                    event.m_246326_((ItemLike)CreateItems.PETROLIUM_BOTTLE.get());
                    event.m_246326_((ItemLike)CreateFluids.YELLOWCAKE_FLUID.getBucket().get());
                }
            }
            if (valkyrienWariumLoaded && event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"valkyrien_warium", (String)"warium_vs"))) {
                event.accept(RegistryItems.CONTROLLABLE_TRIGGER);
            }
        }
    }
}

