/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.block.converter;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import crazywoddman.warium_additions.block.converter.RotationConverterBlock;
import crazywoddman.warium_additions.block.converter.RotationConverterBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationConverterRenderer
extends KineticBlockEntityRenderer<RotationConverterBlockEntity> {
    public RotationConverterRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected SuperByteBuffer getRotatedModel(RotationConverterBlockEntity blockEntity, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)RotationConverterBlock.FACING);
        return CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)facing.m_122424_());
    }

    protected void renderSafe(RotationConverterBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)blockEntity.m_58904_())) {
            return;
        }
        super.renderSafe((KineticBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)RotationConverterBlock.FACING);
        AttachFace face = (AttachFace)state.m_61143_(RotationConverterBlock.FACE);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        SuperByteBuffer shaftHalf = CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)facing.m_122424_());
        RotationConverterRenderer.standardKineticRotationTransform((SuperByteBuffer)shaftHalf, (KineticBlockEntity)blockEntity, (int)light).renderInto(ms, vb);
        SuperByteBuffer dialBuffer = CachedBufferer.partial((PartialModel)AllPartialModels.GAUGE_DIAL, (BlockState)state);
        SuperByteBuffer headBuffer = CachedBufferer.partial((PartialModel)AllPartialModels.GAUGE_HEAD_SPEED, (BlockState)state);
        float dialPivot = 0.359375f;
        float progress = Mth.m_14179_((float)partialTicks, (float)blockEntity.prevDialState, (float)blockEntity.dialState);
        if (face == AttachFace.WALL) {
            this.renderGaugePanelWall(ms, vb, dialBuffer, headBuffer, facing, -0.0625f, dialPivot, progress, light, overlay);
            this.renderGaugePanelWall(ms, vb, dialBuffer, headBuffer, facing.m_122424_(), 0.0625f, dialPivot, progress, light, overlay);
        } else {
            this.renderGaugePanel(ms, vb, dialBuffer, headBuffer, facing, face, dialPivot, progress, light, overlay);
        }
    }

    private void renderGaugePanelWall(PoseStack ms, VertexConsumer vb, SuperByteBuffer dialBuffer, SuperByteBuffer headBuffer, Direction panelFacing, float offset, float dialPivot, float progress, int light, int overlay) {
        ((SuperByteBuffer)dialBuffer.rotateCentered(Direction.UP, (float)((double)(-panelFacing.m_122435_() / 180.0f) * Math.PI)).translate(0.0, 0.0, (double)offset).translate(0.0, (double)dialPivot, (double)dialPivot).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress)))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot)).light(light).renderInto(ms, vb);
        headBuffer.rotateCentered(Direction.UP, (float)((double)(-panelFacing.m_122435_() / 180.0f) * Math.PI)).translate(0.0, 0.0, (double)offset).light(light).renderInto(ms, vb);
    }

    private void renderGaugePanel(PoseStack ms, VertexConsumer vb, SuperByteBuffer dialBuffer, SuperByteBuffer headBuffer, Direction facing, AttachFace face, float dialPivot, float progress, int light, int overlay) {
        double offset = face == AttachFace.CEILING ? (double)((facing == Direction.SOUTH || facing == Direction.NORTH ? -1.0f : 1.0f) / 16.0f) : -0.0625;
        ((SuperByteBuffer)dialBuffer.rotateCentered(Direction.NORTH, (float)(face == AttachFace.FLOOR ? -1 : 1) * (float)Math.PI / 2.0f).rotateCentered(Direction.EAST, (90.0f - facing.m_122435_()) / 180.0f * (float)Math.PI).translate(0.0, offset, 0.0).translate(0.0, (double)dialPivot, (double)dialPivot).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress)))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot)).light(light).renderInto(ms, vb);
        headBuffer.rotateCentered(Direction.NORTH, (float)(face == AttachFace.FLOOR ? -1 : 1) * (float)Math.PI / 2.0f).rotateCentered(Direction.EAST, (90.0f - facing.m_122435_()) / 180.0f * (float)Math.PI).translate(0.0, offset, 0.0).light(light).renderInto(ms, vb);
    }
}

