/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import crazywoddman.warium_additions.jei.OilRefineryRecipes;
import crazywoddman.warium_additions.jei.WariumJEI;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;

public class OilRefineryCategory
implements IRecipeCategory<OilRefineryRecipes> {
    public static final RecipeType<OilRefineryRecipes> TYPE = RecipeType.create((String)"crusty_chunks", (String)"refinery", OilRefineryRecipes.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;

    private int ticks() {
        return (int)(System.currentTimeMillis() / 50L);
    }

    private int firebox() {
        return this.ticks() / 20 % 3;
    }

    public OilRefineryCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(63, 121);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("refinery"));
        this.slot = guiHelper.getSlotDrawable();
    }

    public RecipeType<OilRefineryRecipes> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Oil Refinery");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OilRefineryRecipes recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addInputSlot(1, 82).addItemStack(recipe.getInput())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addOutputSlot(1, 64).addFluidStack(recipe.getOutput1().getFluid(), (long)recipe.getOutput1().getAmount())).setBackground(this.slot, -1, -1).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Can be collected with bucket").m_130940_(ChatFormatting.GOLD)));
        ((IRecipeSlotBuilder)builder.addOutputSlot(1, 46).addFluidStack(recipe.getOutput2().getFluid(), (long)recipe.getOutput2().getAmount())).setBackground(this.slot, -1, -1).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Can be collected with bucket").m_130940_(ChatFormatting.GOLD)));
        ((IRecipeSlotBuilder)builder.addOutputSlot(1, 28).addFluidStack(recipe.getOutput3().getFluid(), (long)recipe.getOutput3().getAmount())).setBackground(this.slot, -1, -1).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Can be collected with bucket").m_130940_(ChatFormatting.GOLD)));
        ((IRecipeSlotBuilder)builder.addOutputSlot(1, 10).addFluidStack(recipe.getOutput4().getFluid(), (long)recipe.getOutput4().getAmount())).setBackground(this.slot, -1, -1).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Can be collected with bucket").m_130940_(ChatFormatting.GOLD)));
    }

    public void draw(OilRefineryRecipes recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        int i;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(21.0f, 0.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.25f, 0.25f, 1.0f);
        graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"warium_additions", (String)(switch (this.firebox()) {
            case 1 -> "textures/jei/refinery_kerosene.png";
            case 2 -> "textures/jei/refinery_electric.png";
            default -> "textures/jei/refinery_firebox.png";
        })), 0, 0, 0.0f, 0.0f, 169, 489, 169, 489);
        graphics.m_280168_().m_85849_();
        for (i = 0; i < 7; ++i) {
            Random rand = new Random((long)(this.ticks() / 40) * 1000L + (long)i * 7919L);
            int life = 20 + rand.nextInt(21);
            if (this.ticks() % 40 > life) continue;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(10 + rand.nextInt(67)), (float)(75 + rand.nextInt(41)), 0.0f);
            graphics.m_280168_().m_85841_(1.0f - (float)(this.ticks() % 40) / (float)life, 1.0f - (float)(this.ticks() % 40) / (float)life, 1.0f);
            graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/particle/flame.png"), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.m_280168_().m_85849_();
        }
        RenderSystem.enableBlend();
        for (i = 0; i < 6; ++i) {
            for (int e = 0; e <= 4; ++e) {
                Random rand;
                int life;
                int epoch = this.ticks() / 40 - e;
                int birthTick = epoch * 40;
                int age = this.ticks() - birthTick;
                if (age < 0 || age > (life = 80 + (rand = new Random((long)epoch * 2000L + (long)i * 12345L)).nextInt(41))) continue;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)(10 + rand.nextInt(57)) + (float)Math.cos((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 8.0f * (float)age / (float)life, (float)(75 + rand.nextInt(41)) + (float)Math.sin((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 8.0f * (float)age / (float)life, 0.0f);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f - (float)age / (float)life);
                graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/particle/big_smoke_" + rand.nextInt(12) + ".png")), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
        }
        for (int e = 0; e < 7; ++e) {
            int epoch = this.ticks() / 20 - e;
            int age = this.ticks() - epoch * 20;
            if (age < 0 || age >= 100) continue;
            Random rand = new Random((long)epoch * 12345L);
            float scale = 1.5f + rand.nextFloat() * 1.3f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(23.0f + (rand.nextFloat() - 0.5f) * 3.0f, -15.0f - (float)age * 1.5f, 0.0f);
            graphics.m_280168_().m_85841_(scale, scale, 1.0f);
            graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)("textures/particle/fireball_" + (age / 10 + 1) + ".png")), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.m_280168_().m_85849_();
        }
        if (mouseX >= 21.0 && mouseX <= 63.0 && mouseY >= 0.0 && mouseY <= 83.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("refinery_tower"), (int)mouseX, (int)mouseY);
        }
        if (mouseX >= 28.0 && mouseX <= 56.0 && mouseY >= 84.0 && mouseY <= 100.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("refinery"), (int)mouseX, (int)mouseY);
        }
        if (mouseX >= 28.0 && mouseX <= 56.0 && mouseY >= 101.0 && mouseY <= 121.0) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.addAll((switch (this.firebox()) {
                case 0 -> WariumAdditionsUtil.getWariumStack("firebox");
                case 1 -> WariumAdditionsUtil.getWariumStack("oil_firebox");
                case 2 -> WariumAdditionsUtil.getWariumStack("electric_firebox");
                default -> WariumAdditionsUtil.getWariumStack("firebox");
            }).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)));
            tooltip.add(1, Component.m_237113_((String)(switch (this.firebox()) {
                case 0 -> "Must be fueled";
                case 1 -> "Must be fueled";
                case 2 -> "Must be powered";
                default -> "Must be fueled";
            })).m_130940_(ChatFormatting.GOLD));
            graphics.m_280245_(Minecraft.m_91087_().f_91062_, tooltip.stream().map(Component::m_7532_).toList(), (int)mouseX, (int)mouseY);
        }
    }

    public boolean handleInput(OilRefineryRecipes recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && input.m_84873_() == 0 && WariumJEI.jeiRuntime != null) {
            if (mouseX >= 21.0 && mouseX <= 63.0 && mouseY >= 0.0 && mouseY <= 83.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("refinery_tower"))));
                return true;
            }
            if (mouseX >= 28.0 && mouseX <= 56.0 && mouseY >= 84.0 && mouseY <= 100.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("refinery"))));
                return true;
            }
            if (mouseX >= 28.0 && mouseX <= 56.0 && mouseY >= 101.0 && mouseY <= 121.0) {
                IRecipesGui iRecipesGui = WariumJEI.jeiRuntime.getRecipesGui();
                IFocusFactory iFocusFactory = WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory();
                iRecipesGui.show(List.of(iFocusFactory.createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)(switch (this.firebox()) {
                    case 0 -> WariumAdditionsUtil.getWariumStack("firebox");
                    case 1 -> WariumAdditionsUtil.getWariumStack("oil_firebox");
                    case 2 -> WariumAdditionsUtil.getWariumStack("electric_firebox");
                    default -> WariumAdditionsUtil.getWariumStack("firebox");
                }))));
                return true;
            }
        }
        return false;
    }
}

