/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.create;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.List;
import java.util.Optional;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.mcreator.crustychunks.block.entity.ElectricFireboxBlockEntity;
import net.mcreator.crustychunks.block.entity.EnergyBatteryBlockEntity;
import net.mcreator.crustychunks.block.entity.GeneratorBlockEntity;
import net.mcreator.crustychunks.block.entity.LargeElectricMotorBlockEntity;
import net.mcreator.crustychunks.block.entity.PowerReactorPortBlockEntity;
import net.mcreator.crustychunks.block.entity.SolarGeneratorBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;

@Restriction(require={@Condition(value="create", versionPredicates={"[0.5.1.j]"})})
@Mixin(value={ElectricFireboxBlockEntity.class, LargeElectricMotorBlockEntity.class, GeneratorBlockEntity.class, EnergyBatteryBlockEntity.class, PowerReactorPortBlockEntity.class, SolarGeneratorBlockEntity.class}, remap=false)
public abstract class EnergyTooltipProvider
implements IHaveGoggleInformation {
    private final int fireboxConsumption;
    private final int solarGeneration;

    public EnergyTooltipProvider() {
        this.fireboxConsumption = (Integer)Config.SERVER.electricFireboxConsumption.get();
        this.solarGeneration = (Integer)Config.SERVER.solarGeneration.get();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity = (BlockEntity)this;
        Optional resolve = blockEntity.getCapability(ForgeCapabilities.ENERGY).resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)resolve.get();
        String type = ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_()).m_135815_();
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)("block.crusty_chunks." + type))).m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.AQUA));
        if (List.of("energy_battery", "electric_firebox", "power_reactor_port").contains(type)) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.stored")).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237113_((String)WariumAdditionsUtil.formatFE(energyStorage.getEnergyStored()))).m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.capacity")).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237113_((String)WariumAdditionsUtil.formatFE(energyStorage.getMaxEnergyStored()))).m_130940_(ChatFormatting.AQUA));
        }
        if (!List.of("energy_battery", "power_reactor_port").contains(type)) {
            Level level = blockEntity.m_58904_();
            BlockPos pos = blockEntity.m_58899_();
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)(List.of("electric_firebox", "large_electric_motor").contains(type) ? "createaddition.tooltip.energy.consumption" : "createaddition.tooltip.energy.production"))).m_130940_(ChatFormatting.GRAY));
            MutableComponent mutableComponent = Component.m_237113_((String)"     ");
            tooltip.add((Component)mutableComponent.m_7220_((Component)Component.m_237113_((String)(WariumAdditionsUtil.formatFE(switch (type) {
                case "electric_firebox" -> {
                    if (level.m_276867_(pos)) {
                        yield 0;
                    }
                    yield this.fireboxConsumption;
                }
                case "generator" -> energyStorage.getEnergyStored();
                case "large_electric_motor" -> energyStorage.getEnergyStored();
                case "solar_generator" -> {
                    if (level.m_46461_() && level.m_46861_(pos)) {
                        yield this.solarGeneration;
                    }
                    yield 0;
                }
                default -> 0;
            }) + "/t"))).m_130940_(ChatFormatting.AQUA));
        }
        return true;
    }
}

