/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.crusty_chunks.fluid;

import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import net.mcreator.crustychunks.block.entity.BlockMinerBlockEntity;
import net.mcreator.crustychunks.block.entity.OilFireboxBlockEntity;
import net.mcreator.crustychunks.block.entity.RefineryTowerBlockEntity;
import net.mcreator.crustychunks.init.CrustyChunksModFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RefineryTowerBlockEntity.class, OilFireboxBlockEntity.class, BlockMinerBlockEntity.class})
public class UniqueTankBlockEntitiesMixin {
    @Unique
    private FluidTank fluidTank;

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void injectFluidTank(BlockPos position, BlockState state, CallbackInfo ci) {
        String type;
        final BlockEntity blockEntity = (BlockEntity)this;
        this.fluidTank = new FluidTank(switch (type = ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_()).m_135815_()) {
            case "oil_firebox" -> (Integer)Config.SERVER.oilFireboxCapacity.get();
            case "block_miner" -> (Integer)Config.SERVER.blockMinerCapacity.get();
            default -> (Integer)Config.SERVER.refineryTowerCapacity.get();
        }){

            protected void onContentsChanged() {
                super.onContentsChanged();
                blockEntity.m_58904_().m_7260_(blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity.m_58900_(), 2);
            }

            public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
                Fluid fluid = UniqueTankBlockEntitiesMixin.this.fluidTank.getFluid().getFluid();
                return super.fill(fluid != Fluids.f_76191_ && WariumAdditionsUtil.compareFluids(stack.getFluid(), fluid) ? new FluidStack(fluid, stack.getAmount()) : stack, action);
            }
        };
        this.fluidTank.setValidator(fluidStack -> {
            Fluid fluid = fluidStack.getFluid();
            return WariumAdditionsUtil.compareFluids(fluid, switch (type) {
                case "oil_firebox" -> (FlowingFluid)CrustyChunksModFluids.KEROSENE.get();
                case "block_miner" -> (FlowingFluid)CrustyChunksModFluids.DIESEL.get();
                default -> fluid;
            });
        });
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void injectFluidRead(CompoundTag tag, CallbackInfo ci) {
        this.fluidTank.readFromNBT(tag.m_128469_("fluidTank"));
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void injectFluidSave(CompoundTag tag, CallbackInfo ci) {
        tag.m_128365_("fluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectFluidCapability(Capability<?> capability, Direction facing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            cir.setReturnValue((Object)LazyOptional.of(() -> this.fluidTank).cast());
        }
    }
}

