/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.block.converter;

import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.ThrottleProvider;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RotationConverterBlockEntity
extends SpeedGaugeBlockEntity {
    private final int kineticToStressRatio;
    private final int kineticToSpeedRatio;
    private final int maxThrottle;
    private int lastThrottle;
    private int lastSignal;

    public RotationConverterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.kineticToStressRatio = (Integer)Config.SERVER.kineticToStressRatio.get();
        this.kineticToSpeedRatio = (Integer)Config.SERVER.kineticToSpeedRatio.get();
        this.maxThrottle = (Integer)Config.SERVER.maxThrottle.get();
        this.setLazyTickRate(5);
    }

    private float scaleFromSignal(float value) {
        return this.lastSignal > 0 ? value / 15.0f * (float)(15 - this.lastSignal) : value;
    }

    public void lazyTick() {
        super.lazyTick();
        int signal = this.f_58857_.m_277086_(this.m_58899_());
        int throttle = Math.abs(ThrottleProvider.get((BlockEntity)this, this.maxThrottle));
        if (this.lastThrottle != throttle || this.lastSignal != signal) {
            this.lastThrottle = throttle;
            this.lastSignal = signal;
            if (this.f_58857_.f_46443_) {
                return;
            }
            KineticNetwork network = this.getOrCreateNetwork();
            if (network != null) {
                network.updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            }
            this.onSpeedChanged(this.speed);
        }
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        float speed = Math.round(Math.abs(this.scaleFromSignal(this.getSpeed())) / (float)this.maxThrottle * (float)this.lastThrottle * 10.0f) / 10;
        this.getPersistentData().m_128347_("KineticPower", (double)(speed / (float)this.kineticToSpeedRatio));
        this.dialTarget = RotationConverterBlockEntity.getDialTarget((float)speed);
        this.color = Color.mixColors((int)IRotate.SpeedLevel.of((float)speed).getColor(), (int)0xFFFFFF, (float)0.25f);
        this.notifyUpdate();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)Math.round(this.scaleFromSignal(this.kineticToStressRatio) / (float)this.kineticToSpeedRatio / (float)this.maxThrottle * (float)this.lastThrottle);
        return impact;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"gui.gauge.info_header", (Object[])new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip);
        Lang.translate((String)"gui.speedometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText((float)(this.scaleFromSignal(this.getSpeed()) / (float)this.maxThrottle * (float)this.lastThrottle), (boolean)this.overStressed).forGoggles(tooltip);
        this.addStressImpactStats(tooltip, this.calculateStressApplied());
        return true;
    }
}

