/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.block.converter;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import crazywoddman.warium_additions.block.converter.RotationConverterBlock;
import crazywoddman.warium_additions.block.converter.RotationConverterBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationConverterInstance
extends KineticBlockEntityInstance<RotationConverterBlockEntity>
implements DynamicInstance {
    protected final RotatingData shaft;
    protected final ModelData dial;
    protected final ModelData head;
    protected final ModelData dial2;
    protected final ModelData head2;
    protected final PoseStack ms;
    final Direction facing;
    final Direction opposite;
    final AttachFace face;

    public RotationConverterInstance(MaterialManager materialManager, RotationConverterBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.facing = (Direction)this.blockState.m_61143_((Property)RotationConverterBlock.FACING);
        this.face = (AttachFace)this.blockState.m_61143_(RotationConverterBlock.FACE);
        this.opposite = this.facing.m_122424_();
        this.shaft = (RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, this.opposite).createInstance();
        this.setup(this.shaft);
        Instancer dialModel = this.getTransformMaterial().getModel(AllPartialModels.GAUGE_DIAL, this.blockState);
        Instancer headModel = this.getTransformMaterial().getModel(AllPartialModels.GAUGE_HEAD_SPEED, this.blockState);
        this.ms = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)this.ms);
        msr.translate((Vec3i)this.getInstancePosition());
        float progress = Mth.m_14179_((float)0.0f, (float)blockEntity.prevDialState, (float)blockEntity.dialState);
        this.dial = (ModelData)dialModel.createInstance();
        this.head = (ModelData)headModel.createInstance();
        if (this.face == AttachFace.WALL) {
            this.dial2 = (ModelData)dialModel.createInstance();
            this.head2 = (ModelData)headModel.createInstance();
        } else {
            this.dial2 = null;
            this.head2 = null;
        }
        this.setupDialTransform(msr, progress);
    }

    public void beginFrame() {
        if (Mth.m_14033_((float)((RotationConverterBlockEntity)this.blockEntity).prevDialState, (float)((RotationConverterBlockEntity)this.blockEntity).dialState)) {
            return;
        }
        float progress = Mth.m_14179_((float)0.0f, (float)((RotationConverterBlockEntity)this.blockEntity).prevDialState, (float)((RotationConverterBlockEntity)this.blockEntity).dialState);
        TransformStack msr = TransformStack.cast((PoseStack)this.ms);
        this.setupDialTransform(msr, progress);
    }

    private void setupDialTransform(TransformStack msr, float progress) {
        float dialPivot = 0.359375f;
        msr.pushPose();
        if (this.face == AttachFace.WALL) {
            ((TransformStack)((TransformStack)msr.centre()).rotate(Direction.UP, (float)((double)(-this.facing.m_122435_() / 180.0f) * Math.PI))).unCentre();
            msr.translate(0.0, 0.0, -0.0625);
            this.head.setTransform(this.ms);
            ((TransformStack)((TransformStack)msr.translate(0.0, (double)dialPivot, (double)dialPivot)).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress)))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot));
            this.dial.setTransform(this.ms);
            msr.popPose();
            msr.pushPose();
            ((TransformStack)((TransformStack)msr.centre()).rotate(Direction.UP, -this.opposite.m_122435_() / 180.0f * (float)Math.PI)).unCentre();
            msr.translate(0.0, 0.0, 0.0625);
            this.head2.setTransform(this.ms);
            ((TransformStack)((TransformStack)msr.translate(0.0, (double)dialPivot, (double)dialPivot)).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress)))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot));
            this.dial2.setTransform(this.ms);
        } else {
            ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotate(Direction.NORTH, (float)(this.face == AttachFace.FLOOR ? -1 : 1) * (float)Math.PI / 2.0f)).rotate(Direction.EAST, (90.0f - this.facing.m_122435_()) / 180.0f * (float)Math.PI)).unCentre();
            if (this.face == AttachFace.CEILING) {
                msr.translate(0.0, (double)((this.facing == Direction.SOUTH || this.facing == Direction.NORTH ? -1.0f : 1.0f) / 16.0f), 0.0);
            } else {
                msr.translate(0.0, -0.0625, 0.0);
            }
            this.head.setTransform(this.ms);
            ((TransformStack)((TransformStack)msr.translate(0.0, (double)dialPivot, (double)dialPivot)).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress)))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot));
            this.dial.setTransform(this.ms);
        }
        msr.popPose();
    }

    public void update() {
        this.updateRotation(this.shaft);
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.dial, this.head});
        if (this.dial2 != null && this.head2 != null) {
            this.relight(this.pos, new FlatLit[]{this.dial2, this.head2});
        }
    }

    public void remove() {
        this.shaft.delete();
        this.dial.delete();
        this.head.delete();
        if (this.dial2 != null) {
            this.dial2.delete();
        }
        if (this.head2 != null) {
            this.head2.delete();
        }
    }
}

