/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.jei;

import com.mojang.blaze3d.platform.InputConstants;
import crazywoddman.warium_additions.jei.CentrifugeRecipes;
import crazywoddman.warium_additions.jei.WariumJEI;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.List;
import java.util.Random;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CentrifugeCategory
implements IRecipeCategory<CentrifugeRecipes> {
    public static final RecipeType<CentrifugeRecipes> TYPE = RecipeType.create((String)"crusty_chunks", (String)"centrifuge", CentrifugeRecipes.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;

    private int ticks() {
        return (int)(System.currentTimeMillis() / 50L);
    }

    public CentrifugeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(124, 76);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("centrifuge_core"));
        this.slot = guiHelper.getSlotDrawable();
    }

    public RecipeType<CentrifugeRecipes> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Centrifuge");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CentrifugeRecipes recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addInputSlot(21, 32).addItemStack(recipe.getInput())).setBackground(this.slot, -1, -1).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Centrifuge Core input").m_130940_(ChatFormatting.BLUE)));
        ((IRecipeSlotBuilder)builder.addOutputSlot(21, 12).addItemStack(recipe.getOutputTop())).setBackground(this.slot, -1, -1).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Centrifuge Top output").m_130940_(ChatFormatting.RED)));
        ((IRecipeSlotBuilder)builder.addOutputSlot(21, 52).addItemStack(recipe.getOutputBottom())).setBackground(this.slot, -1, -1).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Centrifuge Bottom output").m_130940_(ChatFormatting.RED)));
    }

    public void draw(CentrifugeRecipes recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(41.0f, 0.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.25f, 0.25f, 1.0f);
        graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"warium_additions", (String)"textures/jei/centrifuge.png"), 0, 0, 0.0f, 0.0f, 253, 304, 253, 304);
        graphics.m_280168_().m_85849_();
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "200s", 100, 68, 0x8B8B8B, false);
        for (int i = 0; i < 10; ++i) {
            for (int e = 0; e <= 3; ++e) {
                int life;
                Random rand = new Random((long)i * 12345L + (long)e * 54321L);
                int epoch = (this.ticks() + rand.nextInt(40)) / 40 - e;
                int birthTick = epoch * 40 - rand.nextInt(40);
                int age = this.ticks() - birthTick;
                if (age < 0 || age > (life = 80 + rand.nextInt(41))) continue;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)(35 + rand.nextInt(57)) + (float)Math.cos((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 48.0f * (float)age / (float)life, (float)(2 + rand.nextInt(72)) + (float)Math.sin((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 48.0f * (float)age / (float)life, 0.0f);
                graphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
                graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/particle/spark_" + this.ticks() / (10 + rand.nextInt(5)) % 8 + ".png")), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
        }
        if (mouseX >= 60.0 && mouseX <= 84.0 && mouseY >= 6.0 && mouseY <= 12.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("centrifuge_top"), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 60.0 && mouseX <= 85.0 && mouseY >= 38.0 && mouseY <= 50.0 || mouseX >= 60.0 && mouseX <= 72.0 && mouseY >= 33.0 && mouseY <= 37.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("centrifuge_core"), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 52.0 && mouseX <= 77.0 && mouseY >= 0.0 && mouseY <= 34.0 || mouseX >= 52.0 && mouseX <= 104.0 && mouseY >= 4.0 && mouseY <= 25.0 || mouseX >= 60.0 && mouseX <= 93.0 && mouseY >= 4.0 && mouseY <= 37.0 || mouseX >= 41.0 && mouseX <= 66.0 && mouseY >= 9.0 && mouseY <= 34.0 || mouseX >= 52.0 && mouseX <= 104.0 && mouseY >= 40.0 && mouseY <= 67.0 || mouseX >= 41.0 && mouseX <= 67.0 && mouseY >= 47.0 && mouseY <= 72.0 || mouseX >= 69.0 && mouseX <= 93.0 && mouseY >= 67.0 && mouseY <= 76.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("giant_coil"), (int)mouseX, (int)mouseY);
        }
    }

    public boolean handleInput(CentrifugeRecipes recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && input.m_84873_() == 0 && WariumJEI.jeiRuntime != null) {
            if (mouseX >= 60.0 && mouseX <= 84.0 && mouseY >= 6.0 && mouseY <= 12.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("centrifuge_top"))));
                return true;
            }
            if (mouseX >= 60.0 && mouseX <= 85.0 && mouseY >= 38.0 && mouseY <= 50.0 || mouseX >= 60.0 && mouseX <= 72.0 && mouseY >= 33.0 && mouseY <= 37.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("centrifuge_core"))));
                return true;
            }
            if (mouseX >= 52.0 && mouseX <= 77.0 && mouseY >= 0.0 && mouseY <= 34.0 || mouseX >= 52.0 && mouseX <= 104.0 && mouseY >= 4.0 && mouseY <= 25.0 || mouseX >= 60.0 && mouseX <= 93.0 && mouseY >= 4.0 && mouseY <= 37.0 || mouseX >= 41.0 && mouseX <= 66.0 && mouseY >= 9.0 && mouseY <= 34.0 || mouseX >= 52.0 && mouseX <= 104.0 && mouseY >= 40.0 && mouseY <= 67.0 || mouseX >= 41.0 && mouseX <= 67.0 && mouseY >= 47.0 && mouseY <= 72.0 || mouseX >= 69.0 && mouseX <= 93.0 && mouseY >= 67.0 && mouseY <= 76.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("giant_coil"))));
                return true;
            }
        }
        return false;
    }
}

