/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import crazywoddman.warium_additions.jei.FoundryRecipes;
import crazywoddman.warium_additions.jei.WariumJEI;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;

public class FoundryCategory
implements IRecipeCategory<FoundryRecipes> {
    public static final RecipeType<FoundryRecipes> TYPE = RecipeType.create((String)"crusty_chunks", (String)"foundry", FoundryRecipes.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable input;
    private final IDrawable output;

    private int ticks() {
        return (int)(System.currentTimeMillis() / 50L);
    }

    private int firebox() {
        return this.ticks() / 20 % 3;
    }

    public FoundryCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/foundry_gui.png"), 6, 7, 164, 72).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("foundry"));
        this.input = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/grayingot.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.output = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/graycyllinder.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public RecipeType<FoundryRecipes> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Foundry");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FoundryRecipes recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addInputSlot(1, 1).addItemStack(recipe.getInputTop())).addTooltipCallback((view, tooltip) -> tooltip.add(1, Component.m_237113_((String)"Not Consumed").m_130940_(ChatFormatting.GOLD)));
        ((IRecipeSlotBuilder)builder.addInputSlot(1, 28).addItemStack(recipe.getInputBottom())).setBackground(this.input, 0, 0);
        ((IRecipeSlotBuilder)builder.addOutputSlot(1, 55).addItemStack(recipe.getOutput())).setBackground(this.output, 0, 0);
    }

    public void draw(FoundryRecipes recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        int i;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(120.0f, 32.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.25f, 0.25f, 1.0f);
        graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"warium_additions", (String)(switch (this.firebox()) {
            case 1 -> "textures/jei/foundry_kerosene.png";
            case 2 -> "textures/jei/foundry_electric.png";
            default -> "textures/jei/foundry_firebox.png";
        })), 0, 0, 0.0f, 0.0f, 93, 160, 93, 160);
        graphics.m_280168_().m_85849_();
        for (i = 0; i < 6; ++i) {
            Random rand = new Random((long)(this.ticks() / 40) * 1000L + (long)i * 7919L);
            int life = 20 + rand.nextInt(21);
            if (this.ticks() % 40 > life) continue;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(100 + rand.nextInt(67)), (float)(32 + rand.nextInt(41)), 0.0f);
            graphics.m_280168_().m_85841_(1.0f - (float)(this.ticks() % 40) / (float)life, 1.0f - (float)(this.ticks() % 40) / (float)life, 1.0f);
            graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/particle/flame.png"), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.m_280168_().m_85849_();
        }
        RenderSystem.enableBlend();
        for (i = 0; i < 7; ++i) {
            for (int e = 0; e <= 4; ++e) {
                Random rand;
                int life;
                int epoch = this.ticks() / 40 - e;
                int birthTick = epoch * 40;
                int age = this.ticks() - birthTick;
                if (age < 0 || age > (life = 80 + (rand = new Random((long)epoch * 2000L + (long)i * 12345L)).nextInt(41))) continue;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)(100 + rand.nextInt(57)) + (float)Math.cos((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 8.0f * (float)age / (float)life, (float)(32 + rand.nextInt(41)) + (float)Math.sin((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 8.0f * (float)age / (float)life, 0.0f);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f - (float)age / (float)life);
                graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/particle/big_smoke_" + rand.nextInt(12) + ".png")), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
        }
        if (mouseX >= 120.0 && mouseX <= 143.0 && mouseY >= 32.0 && mouseY <= 57.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("foundry"), (int)mouseX, (int)mouseY);
        }
        if (mouseX >= 120.0 && mouseX <= 143.0 && mouseY >= 58.0 && mouseY <= 72.0) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.addAll((switch (this.firebox()) {
                case 0 -> WariumAdditionsUtil.getWariumStack("firebox");
                case 1 -> WariumAdditionsUtil.getWariumStack("oil_firebox");
                case 2 -> WariumAdditionsUtil.getWariumStack("electric_firebox");
                default -> WariumAdditionsUtil.getWariumStack("firebox");
            }).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)));
            tooltip.add(1, Component.m_237113_((String)(switch (this.firebox()) {
                case 0 -> "Must be fueled";
                case 1 -> "Must be fueled";
                case 2 -> "Must be powered";
                default -> "Must be fueled";
            })).m_130940_(ChatFormatting.GOLD));
            graphics.m_280245_(Minecraft.m_91087_().f_91062_, tooltip.stream().map(Component::m_7532_).toList(), (int)mouseX, (int)mouseY);
        }
    }

    public boolean handleInput(FoundryRecipes recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && input.m_84873_() == 0 && WariumJEI.jeiRuntime != null) {
            if (mouseX >= 120.0 && mouseX <= 143.0 && mouseY >= 32.0 && mouseY <= 57.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("foundry"))));
                return true;
            }
            if (mouseX >= 120.0 && mouseX <= 143.0 && mouseY >= 58.0 && mouseY <= 72.0) {
                IRecipesGui iRecipesGui = WariumJEI.jeiRuntime.getRecipesGui();
                IFocusFactory iFocusFactory = WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory();
                iRecipesGui.show(List.of(iFocusFactory.createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)(switch (this.firebox()) {
                    case 0 -> WariumAdditionsUtil.getWariumStack("firebox");
                    case 1 -> WariumAdditionsUtil.getWariumStack("oil_firebox");
                    case 2 -> WariumAdditionsUtil.getWariumStack("electric_firebox");
                    default -> WariumAdditionsUtil.getWariumStack("firebox");
                }))));
                return true;
            }
        }
        return false;
    }
}

